

package gov.va.med.cds.exceptionframework;


import static org.junit.Assert.assertEquals;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;
import gov.va.med.cds.junit.runners.Suite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.junit.runner.RunWith;


@RunWith( SuiteAwareRunner.class )
public class ExceptionUtilTest  extends
AbstractBaseTest
{
    private Log logger = LogFactory.getLog( ExceptionUtilTest.class );
    private static final String UNIQUE_REQUEST_ID = "1";


    @Test
    @Suite( groups = { "checkintest" } )
    public void testFormatExceptionMessages( )
    {
        String[] args = new String[] { "XXXXX", "error101" };
        String formattedMsg = ExceptionUtil.formatMessage( "TemplateId {0} is invalid and the error is {1}.", args );
        assertEquals( "TemplateId XXXXX is invalid and the error is error101.", formattedMsg );
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testLogExceptionWithoutExtraMessage( )
    {
        List<ExceptionInfo> exceptionInfoList = new ArrayList<ExceptionInfo>();
        ExceptionInfo exceptionInfo = new ExceptionInfo();

        exceptionInfo.setException( new IOException() );
        exceptionInfoList.add( exceptionInfo );

        ExceptionUtil.logException( exceptionInfoList, LoggingSeverity.ERROR, logger, null, UNIQUE_REQUEST_ID, null );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testLogExceptionWithExtraMessage( )
    {
        ExceptionInfo exceptionInfo = new ExceptionInfo();
        exceptionInfo.setException( new IOException() );

        ExceptionUtil.logException( exceptionInfo, logger, "message to be appended to the exception.getMessage()", null, UNIQUE_REQUEST_ID, null );

    }
}
