

package gov.va.med.cds.exceptionframework;


import gov.va.med.cds.junit.runners.Suite;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;


public class DefaultLoggerTest
{
    Log loggerMock = null;
    DefaultLogger defaultLogger = null;


    @Before
    @Suite( groups = { "checkintest" } )
    public void testBeforeOnceDefaultLoggerTest( )
        throws Exception
    {
        defaultLogger = new DefaultLogger();
        loggerMock = EasyMock.createMock( Log.class );
        setLoggerToMock();
    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testLog1( )
    {
        //Expected call
        loggerMock.error( EasyMock.contains( "#entryPoint#requestId#applicationName#java.lang.Exception,message," ), EasyMock.isA( Exception.class ) );
        EasyMock.replay( loggerMock );
        defaultLogger.log( new Exception(), LoggingSeverity.ERROR, "message", "entryPoint", "requestId", "applicationName" );
        EasyMock.verify( loggerMock );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testLog2( )
    {
        //Expected call
        loggerMock.fatal( EasyMock.contains( "#entryPoint#requestId#applicationName#gov.va.med.cds.exceptionframework.ExceptionInfo,message" ), EasyMock.eq( ( Throwable )null ) );

        EasyMock.replay( loggerMock );
        defaultLogger.log( new ExceptionInfo(), "message", "entryPoint", "requestId", "applicationName" );
        EasyMock.verify( loggerMock );

    }


    @Test
    @Suite( groups = { "checkintest" } )
    public void testLog3( )
    {
        //Expected call
        loggerMock.fatal( EasyMock.contains( "#entryPoint#requestId#applicationName#java.lang.Exception,message,java.lang.Exception message" ), EasyMock.isA( ( Exception.class ) ) );

        EasyMock.replay( loggerMock );
        defaultLogger.log( new Exception(), "message", "entryPoint", "requestId", "applicationName" );
        EasyMock.verify( loggerMock );
    }

    @Test
    @Suite( groups = { "checkintest" } )
    public void testLog4( )
    {
        List<ExceptionInfo> exceptionInfos = new ArrayList<ExceptionInfo>();
        exceptionInfos.add( new ExceptionInfo() );

        //Expected call
        loggerMock.warn( EasyMock.contains( "#entryPoint#requestId#applicationName#gov.va.med.cds.exceptionframework.ExceptionInfo,null,requestId,java.lang.NullPointerException" ), EasyMock.eq( ( Throwable )null ) );

        EasyMock.replay( loggerMock );
        defaultLogger.log( exceptionInfos, LoggingSeverity.WARNING, "entryPoint", "requestId", "applicationName" );
        EasyMock.verify( loggerMock );
    }

    
    /**
     *  Use reflection to set DefaultLogger private field logger to mock
     */
    private void setLoggerToMock( ) throws Exception
    {
        Class<? extends DefaultLogger> obj = defaultLogger.getClass();
        Field field = obj.getDeclaredField( "logger");
        field.setAccessible( true );
        field.set( defaultLogger,  loggerMock );
    }

}
