

package gov.va.med.cds.util;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.dom4j.CDATA;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;


public class QueryCacheValue
{
    private long lastUpdateTime;
    private List<Object> cachedValue;


    @SuppressWarnings("unchecked")
    public QueryCacheValue( List<Object> aResults )
    {
        if ( aResults == null )
        {
            throw new IllegalArgumentException( "The constructor argument results cannot be null" );
        }
        this.cachedValue = ( List<Object> )copy( aResults );
        lastUpdateTime = System.currentTimeMillis();
    }


    public long getLastUpdateTime( )
    {
        return lastUpdateTime;
    }


    @SuppressWarnings("unchecked")
    public List<Object> getCachedValue( )
    {
        return ( List<Object> )copy( cachedValue );
    }


    /**
     * indicates whether this QueryCacheValue's age is greater than the argument
     * time in seconds.
     **/
    public boolean exceedsMaxAge( long aMaxAgeInSeconds )
    {
        if ( aMaxAgeInSeconds <= 0 )
        {
            return false;
        }
        long maxAgeTime = aMaxAgeInSeconds * 1000;
        long currentTime = System.currentTimeMillis();

        return ( currentTime - maxAgeTime ) > lastUpdateTime;
    }


    @Override
    public String toString( )
    {
        return toElement().asXML();
    }


    public Element toElement( )
    {
        DocumentFactory df = new DocumentFactory();
        Element e = df.createElement( getClass().getSimpleName() );

        Date dt = new Date();
        dt.setTime( lastUpdateTime );
        e.add( df.createAttribute( e, "lastUpdateTime", dt.toString() ) );
        Element contents = df.createElement( "cachedValue" );
        for ( Object item : getCachedValue() )
        {
            if ( item instanceof Element )
            {
                contents.add( ( Element )item );
            }
            else
            {
                CDATA cdata = df.createCDATA( item.toString() );
                contents.add( cdata );
            }
        }
        e.add( contents );

        return e;
    }


    protected final Object cloneList( List<Object> aList )
    {
        List<Object> clonedList = new ArrayList<Object>( aList.size() );
        for ( Object item : aList )
        {
            if ( item instanceof Element )
                clonedList.add( ( ( Element )item ).clone() );
            else
                clonedList.add( copy( item ) );
        }

        return clonedList;
    }


    @SuppressWarnings("unchecked")
    public final Object copy( Object anOriginal )
    {
        Object returnObject = null;

        if ( anOriginal instanceof List<?> )
        {
            returnObject = cloneList( ( List<Object> )anOriginal );
        }
        else if ( anOriginal instanceof Element )
        {
            returnObject = ( ( Element )anOriginal ).clone();
        }
        else if ( anOriginal instanceof Serializable )
        {
            returnObject = copyViaSerialization( ( Serializable )anOriginal );
        }
        else
        {
            throw new RuntimeException( "object to copy [" + anOriginal + "] could not be copied via cloning nor by Serialization" );
        }

        return returnObject;
    }


    protected final Object copyViaSerialization( Serializable anOriginal )
    {
        Object returnObject = null;

        if ( anOriginal == null )
        {
            throw new NullPointerException( "Serializable argument cannot be null" );
        }

        try
        {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream( bos );
            out.writeObject( anOriginal );
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream( new ByteArrayInputStream( bos.toByteArray() ) );
            returnObject = in.readObject();
        }
        catch ( Exception e )
        {
            throw new RuntimeException( e );
        }

        return returnObject;
    }


    @Override
    public boolean equals( Object anObject )
    {
        try
        {
            return cachedValue.equals( ( ( QueryCacheValue )anObject ).cachedValue );
        }
        catch ( Exception e )
        {
            return false;
        }
    }


    @Override
    public int hashCode( )
    {
        return Arrays.hashCode( new Object[] { cachedValue } );
    }

}
