

package gov.va.med.cds.util;


import java.util.HashMap;
import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;


public class QueryCacheUtil
{
    /**
     * returns a List of the related Hibernate Objects. If the QueryCacheManager
     * is enabled, then cached results will be returned if found. Otherwise, the
     * results of a hibernate <code>query.list()</code> are returned. The
     * returned results will be cached if the Hibernate Caching is enabled.
     * 
     * @param session
     *            the hibernate session
     * @param queryName
     *            the hibernate named query
     * @param paramName
     *            the name of the param found in the named query
     * @param paramValue
     *            the value of the param to be set in the named query
     * @return
     */
    public List<Object> getNamedQueryList( Session session, String queryName, String paramName, Object paramValue )
    {
        List<Object> returnNamedQueryList = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        /*
         * JLA Fortify Quality Code Scan - Dead Code: Expression is Always true
         *   commenting out if
        if ( paramName != null && !paramName.trim().equals( "" ) && paramValue != null )
            params.put( paramName, paramValue );
         */
        params.put( paramName, paramValue );
        returnNamedQueryList = getNamedQueryList( session, queryName, params );
        
        return returnNamedQueryList;
    }


    public List<Object> getNamedQueryList( Session session, String queryName, String paramName1, Object paramValue1, String paramName2,
            Object paramValue2 )
    {
        List<Object> returnNamedQueryList = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        /*
         * JLA Fortify Quality Code Scan - Dead Code: Expression is Always true
         *   commenting out if
        if ( paramName1 != null && !paramName1.trim().equals( "" ) && paramValue1 != null )
            params.put( paramName1, paramValue1 );
        if ( paramName2 != null && !paramName2.trim().equals( "" ) && paramValue2 != null )
            params.put( paramName2, paramValue2 );
         */
        params.put( paramName1, paramValue1 );
        params.put( paramName2, paramValue2 );
        returnNamedQueryList = getNamedQueryList( session, queryName, params );
        
        return returnNamedQueryList;
    }


    @SuppressWarnings("unchecked")
    public List<Object> getNamedQueryList( Session session, String queryName, HashMap<String, Object> params )
    {
        if ( session == null )
            throw new IllegalArgumentException( "session argument cannot be null" );
        if ( queryName == null )
            throw new IllegalArgumentException( "queryName argument cannot be null" );
        if ( queryName.trim().equals( "" ) )
            throw new IllegalArgumentException( "queryName argument cannot be an empty string" );

        List<Object> elements = QueryCacheManager.getInstance().get( session, queryName, params );
        if ( elements != null )
            return elements;

        Query query = session.getNamedQuery( queryName );
        for ( String paramName : params.keySet() )
        {
            query.setParameter( paramName, params.get( paramName ) );
        }
        elements = query.list();
        QueryCacheManager.getInstance().put( session, queryName, params, elements );
        return elements;
    }


    public List<Object> getQueryList( Session session, String hql, String paramName, Object paramValue )
    {

        HashMap<String, Object> params = new HashMap<String, Object>();
        if ( paramName != null && paramName.trim().equals( "" ) && paramValue != null )
            params.put( paramName, paramValue );
        return getQueryList( session, hql, params );
    }


    public List<Object> getQueryList( Session session, String hql, String paramName1, Object paramValue1, String paramName2,
            Object paramValue2 )
    {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if ( paramName1 != null && paramName1.trim().equals( "" ) && paramValue1 != null )
            params.put( paramName1, paramValue1 );
        if ( paramName2 != null && paramName2.trim().equals( "" ) && paramValue2 != null )
            params.put( paramName2, paramValue2 );
        return getQueryList( session, hql, params );
    }


    @SuppressWarnings("unchecked")
    public List<Object> getQueryList( Session session, String hql, HashMap<String, Object> params )
    {
        if ( hql == null )
            throw new IllegalArgumentException( "queryName argument cannot be null" );
        if ( hql.trim().equals( "" ) )
            throw new IllegalArgumentException( "queryName argument cannot be an empty string" );
        if ( session == null )
            throw new IllegalArgumentException( "session argument cannot be null" );

        List<Object> elements = QueryCacheManager.getInstance().get( session, hql, params );
        if ( elements == null )
        {
            Query query = session.createQuery( hql );
            for ( String paramName : params.keySet() )
            {
                query.setParameter( paramName, params.get( paramName ) );
            }
            elements = query.list();
            QueryCacheManager.getInstance().put( session, hql, params, elements );
        }
        return elements;
    }

}
