
package gov.va.med.cds.util;

import java.util.Locale;
import java.util.Map;

public final class EstimatedCreatinineClearance {

	private static final String AGE = "age";
	private static final String WEIGHT = "weight";
	private static final String GENDER = "gender";

	public String estimatedCreatinineClearance(String anAge, String aWeight, String aGender, String aSerumCreatinineClearance) {

		String age = anAge;
		String gender = aGender.toLowerCase();
		String serumCreatinineClearance = aSerumCreatinineClearance;

		double eCrCl;

		try {
			// Added Local.ENGLISH because Fortify was flagging a Portability
			// Flaw
			if ("female".equals(gender.toLowerCase(Locale.ENGLISH))) {
				eCrCl = ((140 - Integer.parseInt(age)) * (Double.parseDouble(aWeight)) * (0.85)) / (72 * Double.parseDouble(serumCreatinineClearance));
			}
			else { // male and transgender
				eCrCl = ((140 - Integer.parseInt(age)) * (Double.parseDouble(aWeight))) / (72 * Double.parseDouble(serumCreatinineClearance));
			}
		}
		catch (NumberFormatException nfe) {
			return "Unable to compute eCrCl because " + nfe.getMessage();
		}

		return String.valueOf(Math.floor(eCrCl * 100) / 100);
	}

	public String calculateEstimatedCreatinineClearance(Map<String, String> nonQueryParameters, String getFromPayload) {

		return estimatedCreatinineClearance(nonQueryParameters.get(AGE), nonQueryParameters.get(WEIGHT), nonQueryParameters.get(GENDER), getFromPayload);
	}

}
