

package gov.va.med.cds.transaction;


import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkItem;

import java.util.List;


public interface WorkManagerInterface
{
	/**
	 * Schedule new work to happen.
	 * @param work The new work to be done.
	 * @return The work item scheduled to be done.
	 * @throws WorkException If there are problems scheduling the work.
	 */
    WorkItem schedule( Work work ) throws WorkException;

    /**
     * Waiting for all work that has been scheduled to complete. 
     * @param workItems The work items to wait on.
     * @throws WorkException Thrown if waiting is interrupted.
     */
    boolean waitForAll( List<? extends WorkItem> workItems ) throws WorkException;
    
    
    /**
     * Waiting for all work that has been scheduled to complete. 
     * @param workItems The work items to wait on.
     * @param timeout The amount of time to wait before interrupting the thread.
     * @throws WorkException Thrown if waiting is interrupted.
     */
    boolean waitForAll( List<? extends WorkItem> workItems, long timeout ) throws WorkException;
}
