/**
 * 
 */


package gov.va.med.cds.template;


import gov.va.med.cds.request.ErrorSectionHelperInterface;
import gov.va.med.cds.response.WriteResponseGeneratorInterface;
import gov.va.med.cds.response.ResponseAggregatorInterface;
import gov.va.med.cds.response.organizer.ResponseOrganizerInterface;
import gov.va.med.cds.response.sequencer.ResponseSequencerInterface;
import gov.va.med.cds.response.PatientIdentifierDocumentBuilderInterface;


/**
 * @author susarlan
 *
 */
public interface TemplateHelperInterface
{
    /***
     * Get the WriteResponseGeneratorInterface to be used for building a
     * successful write response based on the given template id.  
     * 
     * @param templateId
     * @return WriteResponseGeneratorInterface
     */
    WriteResponseGeneratorInterface getWriteResponseGenerator( String templateId );


    /***
     * Get the ErrorSectionHelperInterface to be used for building an
     * error section based on the given template id.  
     * 
     * @param templateId
     * @return ErrorSectionHelperInterface
     */
    ErrorSectionHelperInterface getErrorSectionHelper( String templateId );


    /***
     * Get the ResponseAggregatorInterface to be used for aggregating the
     * responses based on the given template id.  
     * 
     * @param templateId
     * @return ResponseAggregatorInterface
     */
    ResponseAggregatorInterface getResponseAggregator( String templateId );


    /***
     * Get the ResponseSequencerInterface to be used for sequencing the
     * responses based on the given template id.  
     * 
     * @param templateId
     * @return ResponseSequencerInterface
     */
    ResponseSequencerInterface getResponseSequencer( String templateId );


    /**
     * Get the PatientIdentifierDocumentBuilderInterface to be used for
     * building a Document with Patient search identifier data which
     * will be aggregated into the final response.
     * 
     * @param templateId
     * @return PatientIdentifierDocumentBuilderInterface
     */
    PatientIdentifierDocumentBuilderInterface getPatientIdentifierDocumentBuilder( String templateId );


    /**
     * Get the ResponseOrganizerInterface to be used for ordering the
     * responses based on the given template id. 
     * @param templateId
     *  
     * @return ResponseOrganizerInterface
     */
    ResponseOrganizerInterface getResponseOrganizer( String templateId );


    /**
     * Get the application name give the template ID.
     * @param templateId
     * @return
     */
	String getApplicationName(String templateId);
}
