

package gov.va.med.cds.response.vhim400;


import static gov.va.med.cds.exceptionframework.LoggingSeverity.FATAL;
import gov.va.med.cds.exceptionframework.ExceptionInfo;
import gov.va.med.cds.exceptionframework.LoggingSeverity;
import gov.va.med.cds.request.ErrorSectionHelperInterface;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


public class FlatErrorSectionHelper
    implements
        ErrorSectionHelperInterface
{

    @Override
    public Document buildErrorSection( Document clinicalDataDocument, ExceptionInfo exceptionInfo, String requestId )
    {
        Element errorSectionElement = clinicalDataDocument.getRootElement().element( "errorSection" );

        if ( errorSectionElement == null )
        {
            errorSectionElement = DocumentHelper.createElement( "errorSection" );
            clinicalDataDocument.getRootElement().add( errorSectionElement );
        }

        addErrorToErrorSection( errorSectionElement, exceptionInfo, requestId );

        return clinicalDataDocument;
    }


    @Override
    public int getErrorCount( ErrorType anErrorType, Document aClinicalDataDocument )
    {
        int returnErrorCount = 0;
        
        Element errorSection = aClinicalDataDocument.getRootElement().element( "errorSection" );
        if ( errorSection != null )
        {
            int warnings = errorSection.elements( "warnings" ).size();
            int errors = errorSection.elements( "errors" ).size();
            int fatals = errorSection.elements( "fatalErrors" ).size();

            /*
             * JLA Fortify Quality Code Scan - Dead Code: Expression is always false
             *   commenting out as this code is only used in a test
            switch ( anErrorType )
            {
                case WARNING:
                    return warnings;
                case ERROR:
                    return errors;
                case FATAL:
                    return fatals;
                case ALL:
                default:
                    return warnings + errors + fatals;
            }
             */
            returnErrorCount = warnings + errors + fatals;
        }

        return returnErrorCount;
    }


    private void addErrorToErrorSection( Element errorSectionElement, ExceptionInfo exceptionInfo, String requestId )
    {
        Element errorElement = getErrorElementForSeverity( exceptionInfo.getErrorCode().getLoggingSeverity() );
        errorElement.addElement( "errorId" ).addText( requestId );
        errorElement.addElement( "exception" ).addText( exceptionInfo.getException().getClass().getName() );
        errorElement.addElement( "exceptionMessage" ).addText( exceptionInfo.getException().getMessage() );
        errorElement.addElement( "errorCode" ).addText( exceptionInfo.getErrorCode().name() );
        errorElement.addElement( "displayMessage" ).addText( exceptionInfo.getClientMessage() );
        errorSectionElement.add( errorElement );
    }


    private Element getErrorElementForSeverity( LoggingSeverity loggingSeverity )
    {
        if ( loggingSeverity == null )
        {
            loggingSeverity = FATAL;
        }
        switch ( loggingSeverity )
        {
            case WARNING:
                return DocumentHelper.createElement( "warnings" );
            case ERROR:
                return DocumentHelper.createElement( "errors" );
            case FATAL:
            default:
                return DocumentHelper.createElement( "fatalErrors" );
        }
    }

}