

package gov.va.med.cds.response.strategy;


import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;


public class NonVeteranEmployeeBlobStrategy
    extends
        ReferenceMappingVistaResponseBlobStrategy
{

    @Override
    public Element formatResponse( List<Map<String, Object>> resultList, String domainEntryPoint, String templateId ) throws Exception
    {

        Element results = DocumentHelper.createElement( "results" );

        Document document = DocumentHelper.parseText( extractSensitivePatientAccessBlobData( resultList ) );

        List<Element> blobElementList = document.getRootElement().element( "patients" ).element( "patient" ).elements();

        for ( Element blobElement : blobElementList )
        {
            results.add( blobElement.detach() );
        }

        return results;
    }


    private String extractSensitivePatientAccessBlobData( List<Map<String, Object>> resultList ) throws IOException
    {

        BufferedReader reader = new BufferedReader(
                new InputStreamReader( new java.io.ByteArrayInputStream( ( byte[] )resultList.get( 0 ).get( "stream" ) ) ) );

        String readLine = null;
        StringBuffer response = new StringBuffer();

        do
        {
            readLine = reader.readLine();

            if ( readLine != null )
            {
                response = response.append( readLine );
            }
        }
        while ( readLine != null );

        return "<temp>" + response.toString() + "</temp>";

    }
}