package gov.va.med.cds.persistence.hibernate.rpc;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBaseRpcParamStringBuilder implements RpcParamStringBuilderInterface{
	
	protected String vistaFixedEnvParam = "|E:DT=$P($$NOW^XLFDT,\".\",1)|E:DUZ(\"AG\")=\"\"|E:IO=0|E:DUZ=1|E:DUZ(2)=0|E:U=\"^\"|O:AUDIT=0|O:MRC=200000"; // fixed environment value required by GSP.
	
	//this should be configured and injected
	protected String rpcName;
	protected String patientIdParamName;
	protected String serverParamName;
	protected String commandParamValue;
	protected String argFormat;
	protected String argWithFunctionFormat;
	protected String functionCall = null;
	//list is used to SKIP some parameters provided for Business decisions but that are not wanted/needed for the RPC invoked AND are will not be sent as optional parameters that may be used in the future
	protected List<String> rpcUnusedParamNames = new ArrayList<String>();
	
	
	public void setRpcName(String rpcName){
		this.rpcName=rpcName;
	}
	
	public String getRpcName(){
		return rpcName;
	}
	
	public void setPatientIdParamName(String patientIdParamName){
		this.patientIdParamName=patientIdParamName;
	}
	
	public String getPatientIdParamName(){
		return patientIdParamName;
	}
	
	public String getServerParamName() {
		return serverParamName;
	}

	public void setServerParamName(String serverParamName) {
		this.serverParamName = serverParamName;
	}

	public void setCommandParamValue(String commandParamValue){
		this.commandParamValue=commandParamValue;
	}
	
	public String getCommandParamValue(){
		return commandParamValue;
	}
	
	public void setUnusedRpcParamNames(List<String> rpcUnusedParamNames){
		this.rpcUnusedParamNames=rpcUnusedParamNames;
	}
	
	public List<String> getUnusedRpcParamNames(){
		return rpcUnusedParamNames;
	}
	
	public void setVistaFixedEnvParam(String fixedParam){
		this.vistaFixedEnvParam = fixedParam;
		
	}
	
	public String getFunctionCall() {
		return functionCall;
	}

	public void setFunctionCall(String functionCall) {
		this.functionCall = functionCall;
	}

	public void setArgFormat(String argFormat) {
		this.argFormat = argFormat;
	}

	protected String getArgFormat() {
		return this.argFormat;
	}
	
	public String getArgWithFunctionFormat() {
		return argWithFunctionFormat;
	}

	public void setArgWithFunctionFormat(String argWithFunctionFormat) {
		this.argWithFunctionFormat = argWithFunctionFormat;
	}

	protected boolean prependFunctionToPatient(){
		return functionCall!=null?true:false;
	}
	
	protected boolean addFunctionToDate(){
		return functionCall!=null?true:false;
	}

}
