

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.exception.ErrorCodeEnum;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;


public class VistaRDIPersonNameUserType
    implements
        CompositeUserType
{

    @Override
    public Object nullSafeGet( ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner )
        throws HibernateException,
            SQLException
    {
       
        VistaPersonName person = null;
        if ( rs != null && rs.getString( names[0] ) != null )
        {
            person = new VistaPersonName( rs.getString( names[0] ) );
        }
        else
        {
            return null;
        }

        
        return person;
    }


    @Override
    public void nullSafeSet( PreparedStatement st, Object value, int index, SharedSessionContractImplementor session )
        throws HibernateException,
            SQLException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }


    @Override
    public boolean isMutable( )
    {
        return false;
    }


    @Override
    public Object replace( Object original, Object target, SharedSessionContractImplementor session, Object owner )
        throws HibernateException
    {
        return original;
    }


    @Override
    public void setPropertyValue( Object component, int property, Object value )
        throws HibernateException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }


    @Override
    public Object assemble( Serializable cached, SharedSessionContractImplementor session, Object owner )
        throws HibernateException
    {
        return cached;
    }


    @Override
    public Object deepCopy( Object value )
        throws HibernateException
    {
        return value;
    }


    @Override
    public Serializable disassemble( Object value, SharedSessionContractImplementor session )
        throws HibernateException
    {
        return ( Serializable )value;
    }


    @Override
    public boolean equals( Object x, Object y )
        throws HibernateException
    {
        if ( x == null )
        {
            return false;
        }

        return ( x == y );
    }


    @Override
    public String[] getPropertyNames( )
    {
        return new String[] {""};
    }


    @Override
    public Type[] getPropertyTypes( )
    {
        return new Type[] { StandardBasicTypes.STRING };
    }


    @Override
    public Object getPropertyValue( Object component, int property )
        throws HibernateException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }


    @Override
    public int hashCode( Object x )
        throws HibernateException
    {
        if ( x == null )
        {
            return 0;
        }

        return x.hashCode();
    }


    @Override
    public Class returnedClass( )
    {
        return VistaPersonName.class;
    }
}
