

package gov.va.med.cds.persistence.hibernate.common;


import java.sql.ResultSet;
import java.sql.SQLException;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;


public class VistaPointInTimeUserTypeNoTimezone
    extends
        VistaPointInTimeUserType
{

    public Object nullSafeGet( ResultSet rs, String[] names, SharedSessionContractImplementor sessionImplementor, Object owner )
        throws HibernateException,
            SQLException
    {
        String ts = rs.getString( names[0] );
        if ( ts == null )
        {
            return null;
        }

        String timestamp = vistaTime2String( ts );

       gov.va.med.cds.template.generated.basedatatypes.PointInTime pointInTime = null;
       if ( !rs.wasNull() )
       {
           pointInTime = new gov.va.med.cds.template.generated.basedatatypes.PointInTime();
           pointInTime.setLiteral(timestamp );
       }
       
       return pointInTime;       
    }


    public String vistaTime2String( String aVistaDate )
    {
        String retVal = null;

        if ( ( aVistaDate != null ) && ( aVistaDate.length() >= 3 ) )
        {
            // trim off the time
            // String[] dateTime = vistaDate.split( "\\." );
            String[] dateTime = aVistaDate.split( "[.^]+" );
            aVistaDate = dateTime[0];

            // Filter out non-conformant string dates
            if ( isNonConformatString( aVistaDate ) )
            {
                return aVistaDate;
            }

            // split the time up into date and time parts.
            int dateMaxIndex = ( aVistaDate.length() >= 7 ) ? 7 : aVistaDate.length();
            String datePart = aVistaDate.substring( 0, dateMaxIndex ) + "0000".substring( 0, 7 - dateMaxIndex );

            // add 1700 from the year to match Cache date format
            datePart = ( Integer.parseInt( datePart.substring( 0, 3 ) ) + 1700 ) + datePart.substring( 3 );
            retVal = datePart;

            // // if dateTime array has 3 elements, then order is date, time,
            // facilityId, else date, facilityId
            int timeLength = dateTime.length >= 2 ? dateTime[1].length() : 0;
            String timePart = ( timeLength > 0 ) ? dateTime[1].concat( "000000".substring( 0, 6 - timeLength ) ) : "";
            /*
             * JLA Fortify Quality Code Scan - Poor Style: Value Never Read
             *   commenting out facilityId
            String facilityId = dateTime.length == 2 ? dateTime[1] : dateTime[2];
             */

            // build the new return string from date and time parts
            if ( !"000000".equals( timePart ) )
            {
                retVal = datePart + timePart;
            }
        }
        else
        {
            retVal = aVistaDate;
        }

        return retVal;
    }


    protected String formatHdrTime( String aRawDate, String aNamespace )
    {
        String retVal = null;

        if ( aRawDate != null )
        {
            // trim off the nano-seconds
            String[] dateTime = aRawDate.split( "\\." );
            String dtTime = dateTime[0];
            retVal = dtTime.replaceAll( "[- :]", "" );

            int dateMaxIndex = ( retVal.length() >= 8 ) ? 8 : retVal.length();
            /*
             * JLA Fortify Quality Code Scan - Poor Style: Value Never Read
             *   commenting out datePart
            String datePart = retVal.substring( 0, dateMaxIndex ) + "0000".substring( 0, 8 - dateMaxIndex );
             */
            String timePart = retVal.substring( dateMaxIndex, retVal.length() );

            if ( "000000".equals( timePart ) )
            {
                retVal = retVal.substring( 0, 8 );
            }
        }

        return retVal;
    }
}
