/**
 *
 */


package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.template.generated.basedatatypes.HL72CodedElementLite;
import gov.va.med.cds.template.generated.common.TreatmentFactor;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;


public class VistaOutpatientPharmacyTreatmentFactorType
    extends
        AbstractPointInTimeUserType
{

    public Object getPropertyValue( Object value, int property )
        throws HibernateException
    {
        return null;
    }


    @Override
    public String[] getPropertyNames( )
    {
        return new String[] { "SERVICE_CONNECTED", "MILITARY_SEXUAL_TRAUMA", "AGENT_ORANGE_EXPOSURE", "IONIZING_RADIATION_EXPOSURE", "SouthwestAsiaConditions", "HEAD_ANDOR_NECK_CANCER", "COMBAT_VETERAN", "Proj112Shad" };
    }

    public String[] getPropertyDisplayNames( )
    {
        return new String[] { "SERVICE CONNECTED", "MILITARY SEXUAL TRAUMA", "AGENT ORANGE EXPOSURE", "IONIZING RADIATION EXPOSURE", "SOUTHWEST ASIA CONDITIONS", "HEAD AND/OR NECK CANCER", "COMBAT VETERAN", "PROJ 112/SHAD" };
    }


    @Override
    public Type[] getPropertyTypes( )
    {
        return new Type[] { StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING };
    }


    public Object assemble( Serializable cached, Object owner )
        throws HibernateException
    {
        return cached;
    }


    public Object assemble( Serializable cached, SharedSessionContractImplementor sessionImplementor, Object owner )
        throws HibernateException
    {
        return cached;
    }


    public Object deepCopy( Object value )
        throws HibernateException
    {
        return value;
    }


    public Serializable disassemble( Object value, SharedSessionContractImplementor sessionImplementor )
        throws HibernateException
    {
        return ( Serializable )value;
    }


    public boolean equals( Object x, Object y )
        throws HibernateException
    {
        return false;
    }


    public int hashCode( Object x )
        throws HibernateException
    {
        if ( x == null )
        {
            return 0;
        }

        return x.hashCode();
    }


    public Object nullSafeGet( ResultSet rs, String[] names, SharedSessionContractImplementor sessionImplementor, Object owner )
        throws HibernateException,
            SQLException
    {
        String[] propertyDisplayNames = getPropertyDisplayNames();
        
        
        	List<TreatmentFactor> treatmentFactors = new ArrayList<TreatmentFactor>();
        	for ( int i = 0; i < names.length; i++ )
            {
        			
        		String treatmentFactorType = rs.getString( names[i] );
                if ( treatmentFactorType != null )
                {
                    TreatmentFactor treatmentFactor = new TreatmentFactor();
                	HL72CodedElementLite factor = new HL72CodedElementLite();
                    HL72CodedElementLite factorValue = new HL72CodedElementLite();
                  
                    if ( !rs.wasNull() )
                    {
                        factor.setCode(propertyDisplayNames[i]);
                     
                        if ( treatmentFactorType.equals( "YES" ) )
                        {
                            factorValue.setCode("1");
                            factorValue.setDisplayText("YES");
                        }
                        else
                        {
                        	factorValue.setCode("0");
                            factorValue.setDisplayText("NO");
                        }
                        
                        treatmentFactor.setFactor(factor);
                        treatmentFactor.setFactorValue(factorValue);
                        treatmentFactors.add(treatmentFactor); 
                    }                      
                }   
            
        	if(treatmentFactors.size() > 0)return treatmentFactors;
        }

        return null;
    }


    public void nullSafeSet( PreparedStatement st, Object value, int index, SharedSessionContractImplementor sessionImplementor )
        throws HibernateException,
            SQLException
    {
        throw new UnsupportedOperationException( "VistaReducedReadPersonNameUserType nullSafeSet method not implemented." );
    }


    public Class<PointInTime> returnedClass( )
    {
        return PointInTime.class;
    }


    public int[] sqlTypes( )
    {
        return new int[] { StandardBasicTypes.DATE.sqlType() };
    }

}
