

package gov.va.med.cds.persistence.hibernate.common;


import gov.va.med.cds.exception.ErrorCodeEnum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;

import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;


public class VistaIntegerToStringUserType
    implements
        CompositeUserType
{

    @Override
    public Object nullSafeGet( ResultSet rs, String[] identity, SharedSessionContractImplementor session, Object owner )
        throws HibernateException,
            SQLException
    {
        
        String identityValue = null;
        if ( rs != null && rs.getString( identity[0] ) != null )
        {
        	 //VISTA values have precision - we want an integer in String format
        	try{
        		BigDecimal bdValue = rs.getBigDecimal(identity[0]);
        		DecimalFormat df = new DecimalFormat("#");
            	identityValue = df.format(bdValue);
        	}catch(Exception e){
        		//temp - shouldn't hit this exception, but if so we want to just return an empty value, not crash system.
        		identityValue = null;
        	}
        }
       
       
        return identityValue;
    }


    
    public void nullSafeSet( PreparedStatement st, Object value, int index, SharedSessionContractImplementor sessionImplementor )
            throws HibernateException,
                SQLException
        {
            //this method is implemented to set query parameters in the sql for a read - but not to write data to vista.
            if ( value == null )
            {
                st.setNull( index, StandardBasicTypes.INTEGER.sqlType() );
            }
            else if(value instanceof BigDecimal){
            	st.setBigDecimal(index, (BigDecimal)value);
            }
            else
            {            
            	st.setInt(index, (Integer)value);
            }
        }


    @Override
    public boolean isMutable( )
    {
        return false;
    }


    @Override
    public Object replace( Object original, Object target, SharedSessionContractImplementor session, Object owner )
        throws HibernateException
    {
        return original;
    }


    @Override
    public void setPropertyValue( Object component, int property, Object value )
        throws HibernateException
    {
        throw new UnsupportedOperationException( "VistaIntegerToStringUserType setPropertyValue method not implemented." );

    }


    @Override
    public Object assemble( Serializable cached, SharedSessionContractImplementor session, Object owner )
        throws HibernateException
    {
        return cached;
    }


    @Override
    public Object deepCopy( Object value )
        throws HibernateException
    {
        return value;
    }


    @Override
    public Serializable disassemble( Object value, SharedSessionContractImplementor session )
        throws HibernateException
    {
        return ( Serializable )value;
    }


    @Override
    public boolean equals( Object x, Object y )
        throws HibernateException
    {
        if ( x == null )
        {
            return false;
        }

        return ( x == y );
    }


    @Override
    public String[] getPropertyNames( )
    {
        return new String[] {""};
    }


    @Override
    public Type[] getPropertyTypes( )
    {
        return new Type[] { StandardBasicTypes.STRING };
    }


    @Override
    public Object getPropertyValue( Object component, int property )
        throws HibernateException
    {
        throw new UnsupportedOperationException( new MethodNotImplementedException( ErrorCodeEnum.METHOD_NOT_IMPLEMENTED, this.getClass().getName() ) );
    }


    @Override
    public int hashCode( Object x )
        throws HibernateException
    {
        if ( x == null )
        {
            return 0;
        }

        return x.hashCode();
    }


    @Override
    public Class<BigDecimal> returnedClass( )
    {
        return BigDecimal.class;
    }
}
