

package gov.va.med.cds.persistence.hibernate.common;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class VistaGlobalParser
{
    private final static Log logger = LogFactory.getLog( VistaGlobalParser.class );


    public Map<String, LabTestsParsedFromGlobal> parseGlobal( String aGlobal )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "aGlobal : " + aGlobal );
        }

        List<LabTestsParsedFromGlobal> labTestsParsedFromGlobalList = new ArrayList<LabTestsParsedFromGlobal>();
        Map<String, LabTestsParsedFromGlobal> labTestsParsedFromGlobalMap = new HashMap<String, LabTestsParsedFromGlobal>();

        // 183*122^L^82466.0000!^10958^72!135!288!!!!mg/dL!^^^^500,
        // 489*H^^81004.0000!84930.0000!5767!4344!!!489^65321^71!!!!!!!!!^3130212.165255^^^613^1^^^1

        for ( String testValues : aGlobal.split( "," ) )
        {
            int segmentPositionPointer = 0;

            LabTestsParsedFromGlobal labTestsParsedFromGlobal = new LabTestsParsedFromGlobal();
            labTestsParsedFromGlobal.setPanelTest( false );

            String[] testValueArray = testValues.split( "\\^" );

            for ( String testValueIndividual : testValueArray )
            {
                switch ( segmentPositionPointer )
                {
                    case 0:
                        int segment0Pointer = 0;

                        if ( testValueIndividual.contains( "*" ) )
                        {
                            String[] segment0InfoArray = testValueIndividual.split( "\\*" );

                            for ( String segment0Info : segment0InfoArray )
                            {
                                switch ( segment0Pointer )
                                {
                                    case 0:
                                        labTestsParsedFromGlobal.setLabTestPointer( segment0Info.trim() );
                                        break;
                                    case 1:
                                        labTestsParsedFromGlobal.setObservationValue( segment0Info.trim() );
                                        break;
                                    default:
                                }

                                segment0Pointer++;
                            }
                        }
                        break;

                    case 1:
                        labTestsParsedFromGlobal.setValueInterpretation( testValueIndividual );
                        break;

                    case 2:
                        int segment2Pointer = 0;
                        String[] segment2InfoArray = testValueIndividual.split( "!" );

                        for ( String segment2Info : segment2InfoArray )
                        {

                            switch ( segment2Pointer )
                            {
                                case 0:
                                    // If NLT Code exists, use it for checking
                                    // if test is part of a Panel
                                    labTestsParsedFromGlobal.setNltOrderedTestCode( segment2Info.trim() );
                                    break;
                                case 1:
                                    labTestsParsedFromGlobal.setNltReportedTestCode( segment2Info.trim() );
                                    break;
                                case 2:
                                    labTestsParsedFromGlobal.setLoincCode( segment2Info.trim() );
                                    break;
                                case 3:
                                    labTestsParsedFromGlobal.setSuffixReportedTestCode( segment2Info.trim() );
                                    break;
                                case 6:
                                    labTestsParsedFromGlobal.setTestIdentifier( segment2Info.trim() );
                                    break;
                                default:
                            }

                            segment2Pointer++;
                        }
                        break;

                    case 3:
                        // Segment 3 Verifier Information
                        labTestsParsedFromGlobal.setVerifier( testValueIndividual );
                        break;

                    case 4:
                        int segment4Pointer = 0;
                        String[] segment4InfoArray = testValueIndividual.split( "!" );

                        for ( String segment4Info : segment4InfoArray )
                        {

                            switch ( segment4Pointer )
                            {
                                case 0:
                                    labTestsParsedFromGlobal.setSiteSpecimen( segment4Info.trim() );
                                    break;
                                case 1:
                                    labTestsParsedFromGlobal.setReferenceLow( segment4Info.trim() );
                                    break;
                                case 2:
                                    labTestsParsedFromGlobal.setReferenceHigh( segment4Info.trim() );
                                    break;
                                case 3:
                                    labTestsParsedFromGlobal.setCriticalLow( segment4Info.trim() );
                                    break;
                                case 4:
                                    labTestsParsedFromGlobal.setCriticalHigh( segment4Info.trim() );
                                    break;
                                case 6:
                                    labTestsParsedFromGlobal.setUnitsOfMeasure( segment4Info.trim() );
                                    break;
                                default:
                            }

                            segment4Pointer++;
                        }
                        break;

                    case 8:
                        labTestsParsedFromGlobal.setPerormanceOrgCode( testValueIndividual );
                        break;

                    case 9:
                        labTestsParsedFromGlobal.setAmendedFlag( testValueIndividual );
                        break;

                    default:

                }

                segmentPositionPointer++;
            }

            labTestsParsedFromGlobalList.add( labTestsParsedFromGlobal );

            if ( !labTestsParsedFromGlobalMap.isEmpty() )
            {
                for ( String labTest : labTestsParsedFromGlobalMap.keySet() )
                {
                    String nltOrderedTestCodeOrPanelTestCode = labTestsParsedFromGlobalMap.get( labTest ).getNltOrderedTestCode();

                    if ( ( nltOrderedTestCodeOrPanelTestCode != null ) && ( labTestsParsedFromGlobal != null )
                            && !nltOrderedTestCodeOrPanelTestCode.trim().equals( "" )
                            && ( nltOrderedTestCodeOrPanelTestCode.equals( labTestsParsedFromGlobal.getNltOrderedTestCode() ) ) )
                    {
                        labTestsParsedFromGlobalMap.get( labTest ).setPartOfPanelTest( nltOrderedTestCodeOrPanelTestCode );
                        labTestsParsedFromGlobal.setPartOfPanelTest( nltOrderedTestCodeOrPanelTestCode );

                        labTestsParsedFromGlobalMap.get( labTest ).setPanelTest( true );
                        labTestsParsedFromGlobal.setPanelTest( true );
                    }
                }
            }

            labTestsParsedFromGlobalMap.put( labTestsParsedFromGlobal.getLabTestPointer(), labTestsParsedFromGlobal );
        }

        return labTestsParsedFromGlobalMap;
    }

}
