/**
 * 
 */


package gov.va.med.cds.persistence.hibernate.common;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;

/**
 * A quantity specifying a point on the axis of natural time. A point in time is most often represented as a calendar
 * expression. Semantically, however, time is independent from calendars and best described by its relationship to
 * elapsed time (measured as a physical quantity in the dimension of time.) A point in time plus an elapsed time yields
 * another point in time. Inversely, a point in time minus another point in time yields an elapsed time. As nobody knows
 * when time began, a point in time is conceptualized as the amount of time that has elapsed from some arbitrary
 * zero-point, called an epoch. Because there is no absolute zero-point on the time axis natural time is a
 * difference-scale quantity, where only differences are defined but no ratios. (For example, no point in time is -
 * absolutely speaking - "twice as late" as another point in time.) Given some arbitrary zero-point, one can express any
 * point in time as an elapsed time measured from that offset. Such an arbitrary zero-point is called an epoch. This
 * epoch-offset form is used as a semantic representation here, without implying that any system would have to implement
 * the TS data type in that way. Systems that do not need to compute distances between points in time will not need any
 * other representation than a calendar expression literal
 * 
 * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
 */
public class PointInTime implements BasicType
{
    /**
     * For the default Gregorian calendar the calendar expression literals of this specification conform to the
     * constrained ISO 8601 that is defined in ISO 8824 (ASN.1) under clause 32 (generalized time) and to the HL7
     * version 2 TS data format.
     * 
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String timestamp;


    /**
     * @return the timestamp
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public String getTimestamp( )
    {
        // begin-user-code
        return timestamp;
        // end-user-code
    }


    /**
     * @param theTimestamp the timestamp to set
     * @generated "UML to Java V5.0 (com.ibm.xtools.transform.uml2.java5.internal.UML2JavaTransform)"
     */
    public void setTimestamp( String theTimestamp )
    {
        // begin-user-code
        timestamp = theTimestamp;
        // end-user-code
    }


	@Override
	public Object assemble(Serializable arg0, SharedSessionContractImplementor arg1, Object arg2)
			throws HibernateException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public void beforeAssemble(Serializable arg0, SharedSessionContractImplementor arg1) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public int compare(Object arg0, Object arg1) {
		// TODO Auto-generated method stub
		return 0;
	}


	@Override
	public Object deepCopy(Object arg0, SessionFactoryImplementor arg1) throws HibernateException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public Size[] defaultSizes(Mapping arg0) throws MappingException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public Size[] dictatedSizes(Mapping arg0) throws MappingException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public Serializable disassemble(Object arg0, SharedSessionContractImplementor arg1, Object arg2)
			throws HibernateException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public int getColumnSpan(Mapping arg0) throws MappingException {
		// TODO Auto-generated method stub
		return 0;
	}


	@Override
	public int getHashCode(Object arg0) throws HibernateException {
		// TODO Auto-generated method stub
		return 0;
	}


	@Override
	public int getHashCode(Object arg0, SessionFactoryImplementor arg1) throws HibernateException {
		// TODO Auto-generated method stub
		return 0;
	}


	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public Class getReturnedClass() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public Type getSemiResolvedType(SessionFactoryImplementor arg0) {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public Object hydrate(ResultSet arg0, String[] arg1, SharedSessionContractImplementor arg2, Object arg3)
			throws HibernateException, SQLException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public boolean isAnyType() {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public boolean isAssociationType() {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public boolean isCollectionType() {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public boolean isComponentType() {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public boolean isDirty(Object arg0, Object arg1, SharedSessionContractImplementor arg2) throws HibernateException {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public boolean isDirty(Object arg0, Object arg1, boolean[] arg2, SharedSessionContractImplementor arg3)
			throws HibernateException {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public boolean isEntityType() {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public boolean isEqual(Object arg0, Object arg1) throws HibernateException {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public boolean isEqual(Object arg0, Object arg1, SessionFactoryImplementor arg2) throws HibernateException {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public boolean isModified(Object arg0, Object arg1, boolean[] arg2, SharedSessionContractImplementor arg3)
			throws HibernateException {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public boolean isMutable() {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public boolean isSame(Object arg0, Object arg1) throws HibernateException {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public Object nullSafeGet(ResultSet arg0, String[] arg1, SharedSessionContractImplementor arg2, Object arg3)
			throws HibernateException, SQLException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public Object nullSafeGet(ResultSet arg0, String arg1, SharedSessionContractImplementor arg2, Object arg3)
			throws HibernateException, SQLException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public void nullSafeSet(PreparedStatement arg0, Object arg1, int arg2, SharedSessionContractImplementor arg3)
			throws HibernateException, SQLException {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void nullSafeSet(PreparedStatement arg0, Object arg1, int arg2, boolean[] arg3,
			SharedSessionContractImplementor arg4) throws HibernateException, SQLException {
		// TODO Auto-generated method stub
		
	}


	@Override
	public Object replace(Object arg0, Object arg1, SharedSessionContractImplementor arg2, Object arg3, Map arg4)
			throws HibernateException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public Object replace(Object arg0, Object arg1, SharedSessionContractImplementor arg2, Object arg3, Map arg4,
			ForeignKeyDirection arg5) throws HibernateException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public Object resolve(Object arg0, SharedSessionContractImplementor arg1, Object arg2) throws HibernateException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public Object semiResolve(Object arg0, SharedSessionContractImplementor arg1, Object arg2)
			throws HibernateException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public int[] sqlTypes(Mapping arg0) throws MappingException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public boolean[] toColumnNullness(Object arg0, Mapping arg1) {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public String toLoggableString(Object arg0, SessionFactoryImplementor arg1) throws HibernateException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public String[] getRegistrationKeys() {
		// TODO Auto-generated method stub
		return null;
	}
}
