/**
 *
 */


package gov.va.med.cds.persistence.hibernate.common;


import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;


public class Base64BinaryAttachmentUserType
	implements CompositeUserType
{

    public Object getPropertyValue( Object value, int property )
        throws HibernateException
    {
        return null;
    }

    public String[] getPropertyNames( )
    {
        return new String[] { "blob" };
    }


    public Type[] getPropertyTypes( )
    {
        return new Type[] { StandardBasicTypes.BLOB };
    }


    public Object assemble( Serializable cached, Object owner )
        throws HibernateException
    {
        return cached;
    }


    public Object assemble( Serializable cached, SharedSessionContractImplementor sessionImplementor, Object owner )
        throws HibernateException
    {
        return cached;
    }


    public Object deepCopy( Object value )
        throws HibernateException
    {
        return value;
    }


    public Serializable disassemble( Object value, SharedSessionContractImplementor sessionImplementor )
        throws HibernateException
    {
        return ( Serializable )value;
    }


    public boolean equals( Object x, Object y )
        throws HibernateException
    {
        return false;
    }


    public int hashCode( Object x )
        throws HibernateException
    {
        if ( x == null )
        {
            return 0;
        }

        return x.hashCode();
    }


    public Object nullSafeGet( ResultSet rs, String[] names, SharedSessionContractImplementor sessionImplementor, Object owner )
        throws HibernateException,
            SQLException
    {
    	Blob blob = rs.getBlob(names[0]);
    	if ( blob==null )
    	{ 
    		return null;
    	}
    		throw new java.lang.UnsupportedOperationException("This nullSafeGet method in class " + getClass().getName() + " in NOT supported");
       
    }

    public void nullSafeSet( PreparedStatement st, Object value, int index, SharedSessionContractImplementor sessionImplementor )
        throws HibernateException,
            SQLException
    {
        //this method is implemented to set query parameters in the sql for a read - but not to write data to vista.
        if ( value == null )
        {
            st.setNull( index, StandardBasicTypes.BLOB.sqlType() );
            return;
        }
        if ( value instanceof Element)
        {
        	Element e = (Element)value;
        	String content = e.getTextTrim();
           	ByteArrayInputStream bais = new ByteArrayInputStream(content.getBytes());
           	st.setBlob(index, bais);
           	return;
        }
        
        
       	ByteArrayInputStream bais = new ByteArrayInputStream(value.toString().getBytes());
       	st.setBlob(index, bais);
    }


    public Class<String> returnedClass( )
    {
        return String.class;
    }



    public int[] sqlTypes( )
    {
        return new int[] { StandardBasicTypes.BLOB.sqlType() };
    }


	@Override
	public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
		// TODO Auto-generated method stub
		
	}


	@Override
	public boolean isMutable() {
		// TODO Auto-generated method stub
		return false;
	}


	@Override
	public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner) throws HibernateException {
		// TODO Auto-generated method stub
		return null;
	}


}
