package gov.va.med.cds.persistence.hibernate;

import java.util.List;
import java.util.Map;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

import gov.va.med.cds.filter.EntryFilterInterface;
import gov.va.med.cds.persistence.QueryWorkInterface;
import gov.va.med.cds.util.EstimatedCreatinineClearance;

public class DerivedFieldsModelAssembler extends HibernateDomModelAssembler {

	private EstimatedCreatinineClearance estimatedCreatinineClearance;

	private Map<String, String> parametersToDeriveFrom;

	private Map<String, String> unitsOfMeasure;

	private Map<String, String> deriveFrom;

	protected Map<String, String> addElements;

	public void setUnitsOfMeasure(Map<String, String> unitsOfMeasure) {
		this.unitsOfMeasure = unitsOfMeasure;
	}

	public void setParametersToDeriveFrom(Map<String, String> parametersToDeriveFrom) {
		this.parametersToDeriveFrom = parametersToDeriveFrom;
	}

	public void setAddElements(Map<String, String> addElements) {
		this.addElements = addElements;
	}

	public void setEstimatedCreatinineClearance(EstimatedCreatinineClearance estimatedCreatinineClearance) {
		this.estimatedCreatinineClearance = estimatedCreatinineClearance;
	}

	public void setDeriveFrom(Map<String, String> deriveFrom) {
		this.deriveFrom = deriveFrom;
	}

	@Override
	public Document assembleModel(EntryFilterInterface entryFilter, List<QueryWorkInterface> queryWork) {

		return addDeriveFields(super.assembleModel(entryFilter, queryWork), entryFilter);
	}

	private Document addDeriveFields(Document anAssembleModel, EntryFilterInterface anEntryFilter) {

		String getFromPayload = null;

		Map<String, String> nonQueryParameters = anEntryFilter.getNonQueryParametersMap();

		for (String derivedFieldElementName : addElements.keySet()) {
			
			Node derivedFieldElementNameTemp = anAssembleModel.selectSingleNode(deriveFrom.get(derivedFieldElementName));
			
			if ( null != derivedFieldElementNameTemp)
			{
				getFromPayload = derivedFieldElementNameTemp.getText();
			}
		}

		for (String derivedFieldElementName : addElements.keySet()) {

			Element element = (Element) anAssembleModel.selectSingleNode(addElements.get(derivedFieldElementName));

			Element unitOfMeasure = (Element) anAssembleModel.selectSingleNode(unitsOfMeasure.get(derivedFieldElementName));
			
			if (null != element) {
				if (null != getFromPayload) {
					String calculatedField = estimatedCreatinineClearance.calculateEstimatedCreatinineClearance(nonQueryParameters, getFromPayload);

					if (null != unitOfMeasure) {
						element.addElement(derivedFieldElementName).setText(calculatedField + " " + unitOfMeasure.getText());
					}					
					else {
						element.addElement(derivedFieldElementName).setText(calculatedField+ " " +unitsOfMeasure.get(derivedFieldElementName));
					}
				}
			}
		}

		return anAssembleModel;
	}

}
