/**
 * 
 */


package gov.va.med.cds.persistence.hibernate;


import org.hibernate.Session;

import gov.va.med.cds.clinicaldata.DomainEntryPoint;
import gov.va.med.cds.clinicaldata.Operation;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.hibernate.CensusIDs;
import gov.va.med.cds.template.generated.clinicaldata.Patients;

public interface CensusResponsePersistenceManagerInterface
{

    /**
     * Handles the CUAD requests and applies the transaction to the data-source as directed by the request type.
     * 
     * @param templateId The identifier of the template being created, updated, appended, or deleted.
     * @param requestType - request type could be Create, Update, Append and Delete.
     * @param object - CDM objects to apply to the data-source.     
     * @throws PersistenceException */
    String persistCensusResponse(String templateId, String aRequestId, Operation aOperation,
            DomainEntryPoint domainEntryPoint, Session session, CensusIDs censusIDs,  Patients patients) throws PersistenceException;
}

