

package gov.va.med.cds.persistence;


import gov.va.med.cds.exception.ErrorCodeEnum;

import org.apache.commons.lang3.exception.ExceptionUtils;


/**
 * Handles exceptions thrown by peristence processor.
 * 
 */
public class DeleteException
    extends
        PersistenceException
{

    private static final long serialVersionUID = 4783429399489832692L;


    /**
     * Parent constructor for persistence processor
     * 
     * @param errorCodeName - enum to populate and return to caller.
     */
    public DeleteException( ErrorCodeEnum errorCodeName )
    {
        super( errorCodeName );
    }


    /**
     * Parent constructor for persistence processor
     * 
     * @param errorCodeName - enum to populate and return to caller.
     * @param messages - list of messages to be integrated into exception message.
     */
    public DeleteException( ErrorCodeEnum errorCodeName, String... messages )
    {
        super( errorCodeName, messages );
    }


    /**
     * Parent constructor for persistence processor
     * 
     * @param errorCode - enum to populate and return to caller.
     * @param cause - exception thrown in hibernate persistence module.
     * @param customMsg - list of messages to be integrated into exception message.
     */
    public DeleteException( ErrorCodeEnum errorCode, Throwable cause, String... customMsg )
    {
        super( errorCode, cause, customMsg );
    }


    /**
     * Parent constructor for persistence processor
     * 
     * @param errorCode - enum to populate and return to caller.
     * @param cause - exception thrown in hibernate persistence module.
     */
    public DeleteException( ErrorCodeEnum errorCode, Throwable cause )
    {
        super( errorCode, cause, (ExceptionUtils.getRootCause( cause )==null ? cause.getMessage(): ExceptionUtils.getRootCause( cause ).getMessage()) );
    }
}
