/**
 * 
 */
package gov.va.med.cds.internal;

import java.util.List;

import org.dom4j.Document;

/**
 * @author susarlan
 *
 */
public interface ClinicalDataServiceSynchronousInternalInterface
{
    /**
     * Read clinical data
     *
     * @param filterRequest Filter request specified in VHIM XML format according to the XML from a CDS filter schema
     * @param filterId ID of the named (canned) filter. The filterId may be null if no canned filter is referenced
     * @param templateId ID of the template for which the filter request applies
     * @param requestId Client specified unique request Id
     * @return Results of the read returned in XML according to the CDS read results schema
     */
    List<Document> readClinicalData( String filterRequest, String filterId, String templateId, String requestId );


    /**
     * Create clinical data
     *
     * @param createRequest Write request specified in VHIM XML  format according to the XML from a CDS create request schema
     * @param templateId ID of the template for which the create request applies
     * @param requestId Client specified unique request Id
     * @return Results of the create returned in XML according the CDS create results schema
     */
    Document createClinicalData( String createRequest, String templateId, String requestId );
    /**
     * Create clinical data
     *
     * @param createRequest Write request specified in VHIM XML  format according to the XML from a CDS create request schema
     * @param templateId ID of the template for which the create request applies
     * @param requestId Client specified unique request Id
     * @return Results of the create returned in XML according the CDS create results schema
     */
    List<Document> writeClinicalData( String createRequest, String templateId, String requestId );
    /**
     * Update clinical data
     *
     * @param updateRequest Update request specified in VHIM XML  format according to the XML from a CDS update request schema
     * @param templateId ID of the template for which the update request applies
     * @param requestId Client specified unique request Id
     * @return Results of the update returned in XML according the CDS update results schema
     */
    Document updateClinicalData( String updateRequest, String templateId, String requestId );


    /**
     * Delete clinical data
     *
     * @param deleteRequest Delete request specified in VHIM XML  format according to the XML from a CDS delete request schema
     * @param templateId ID of the template for which the delete request applies
     * @param requestId Client specified unique request Id
     * @return Results of the delete returned in XML according the CDS delete results schema
     */
    Document deleteClinicalData( String deleteRequest, String templateId, String requestId );


    /**
     * Append clinical data
     *
     * @param appendRequest Append request specified in VHIM XML  format according to the XML from a CDS append request schema
     * @param templateId ID of the template for which the append request applies
     * @param requestId Client specified unique request Id
     * @return Results of the append returned in XML according the CDS append results schema
     */
    Document appendClinicalData( String appendRequest, String templateId, String requestId );

}
