<?xml version="1.0" encoding="UTF-8"?>
<?altova_samplexml file:///C:/projects/Saxon/FHIR/data/testVistaAppointmentsPartialReadOneFailure_MultiSite.xml?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns0="Appointmentsdata" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:loc_func="http://www.DNS   /funcs" xmlns:fn="http://www.w3.org/2005/xpath-functions" exclude-result-prefixes="ns0 xs fn loc_func">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<!--xsl:function name="loc_func:date2timeStamp">
		<xsl:param name="dateString"/>
		<xsl:value-of select="( xs:dateTime($dateString) - xs:dateTime('1970-01-01T00:00:00') ) div xs:dayTimeDuration('PT1S')"/>
	</xsl:function-->
	<xsl:function name="loc_func:formatDateTime">
		<xsl:param name="timeStampString"/>
		<xsl:variable name="timezoneOffset">
			<xsl:choose>
				<xsl:when test="fn:contains($timeStampString, '-')">
					<xsl:value-of select="'-'"/>
				</xsl:when>
				<xsl:when test="fn:contains($timeStampString, '+')">
					<xsl:value-of select="'+'"/>
				</xsl:when>
				<xsl:otherwise>
       </xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="format" select="'[Y0001]-[M01]-[D01]T[H01]:[m01]:[s01][Z0000]'"/>
		<xsl:choose>
			<xsl:when test="fn:string-length($timezoneOffset) > 0">
				<xsl:variable name="dateTimeOnly" select="fn:substring-before($timeStampString,$timezoneOffset)"/>
				<xsl:choose>
					<xsl:when test="fn:string-length($dateTimeOnly) = 14">
						<xsl:variable name="timezone" select="fn:number(fn:substring(fn:substring-after($timeStampString,$timezoneOffset),1,2))"/>
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:variable name="timeString" select="fn:concat(fn:substring($timeStampString,9,2),':',fn:substring($timeStampString,11,2),':',fn:substring($timeStampString,13,2))"/>
						<xsl:value-of select="fn:concat($dateString,'T',$timeString,'.',$timezone,'00')"/>
					</xsl:when>
					<xsl:when test="fn:string-length($dateTimeOnly) = 12">
						<xsl:variable name="timezone" select="fn:number(fn:substring(fn:substring-after($timeStampString,$timezoneOffset),1,2))"/>
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:variable name="timeString" select="fn:concat(fn:substring($timeStampString,9,2),':',fn:substring($timeStampString,11,2),':00')"/>
						<xsl:value-of select="fn:concat($dateString,'T',$timeString,'.',$timezone,'00')"/>
					</xsl:when>
					<xsl:when test="fn:string-length( $dateTimeOnly) = 8">
						<xsl:variable name="timezone" select="fn:number(fn:substring(fn:substring-after($timeStampString,$timezoneOffset),1,2))"/>
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:variable name="timeString" select="fn:concat('00:00:00','')"/>
						<xsl:value-of select="fn:concat($dateString,'T',$timeString,'.',$timezone,'00')"/>
					</xsl:when>
					<xsl:otherwise>
						</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="fn:string-length($timeStampString) = 14">
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:variable name="timeString" select="fn:concat(fn:substring($timeStampString,9,2),':',fn:substring($timeStampString,11,2),':',
						 fn:substring($timeStampString,13,2))"/>
						<xsl:value-of select="fn:concat($dateString,'T',$timeString)"/>
					</xsl:when>
					<xsl:when test="fn:string-length($timeStampString ) = 12">
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:variable name="timeString" select="fn:concat(fn:substring($timeStampString,9,2),':',fn:substring($timeStampString,11,2))"/>
						<xsl:value-of select="fn:concat($dateString,'T',$timeString,':00')"/>
					</xsl:when>
					<xsl:when test="fn:string-length($timeStampString) = 8">
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:value-of select="fn:concat($dateString,'T','00:00:00')"/>
					</xsl:when>
					<xsl:otherwise>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<!-- root begin-->
	<xsl:template match="/">
		<!--Bundle xmlns="http://hl7.org/fhir"-->
		<Bundle xmlns="http://hl7.org/fhir" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
			<xsl:attribute name="xsi:schemaLocation">http://hl7.org/fhir http://hl7.org/fhir/fhir-single.xsd</xsl:attribute>
			<xsl:apply-templates select="ns0:*//patients">
			</xsl:apply-templates>
			<xsl:if test="ns0:*//patients/patient/appointments">
				<entry>
					<resource>
						<List>
							<xsl:apply-templates mode="List" select="ns0:AppointmentsData/patients">
	                    </xsl:apply-templates>
							<status>
								<xsl:attribute name="value">
									<xsl:value-of select="'current'"/>
								</xsl:attribute>
							</status>
							<mode>
								<xsl:attribute name="value">
									<xsl:value-of select="'snapshot'"/>
								</xsl:attribute>
							</mode>
							<xsl:variable name="apptIDs" select="ns0:Appointmentsdata/patients/patient/appointments/appointment/recordIdentifier/identity">
		                </xsl:variable>
							<xsl:apply-templates mode="entryIds" select="ns0:AppointmentsData/patients/patient/appointments/appointment/recordIdentifier/identity">
	                    </xsl:apply-templates>
						</List>
					</resource>
				</entry>
			</xsl:if>
			<entry>
				<resource>
					<Parameters>
						<xsl:apply-templates mode="Parameters" select="ns0:AppointmentsData/patients/patient">
				  </xsl:apply-templates>
					</Parameters>
				</resource>
			</entry>
			<xsl:if test="ns0:*//errorSection">
				<entry>
					<resource>
						<!--List-->
						<xsl:apply-templates mode="OperationOutcome" select="ns0:*//errorSection">
	                    </xsl:apply-templates>
						<!--/List-->
					</resource>
				</entry>
			</xsl:if>
			<!--entry>
				<resource>
					
						<xsl:apply-templates mode="OperationOutcome" select="ns0:*//errorSection">
	                    </xsl:apply-templates>
					
				</resource>
			</entry-->
		</Bundle>
	</xsl:template>
	<!-- root end-->
	<!--  Top-level-Bundle Begin -->
	<xsl:template match="patients">
	
		<!--id xmlns="http://hl7.org/fhir">
			<xsl:attribute name="value">
				<xsl:value-of select="../requestId"/>
			</xsl:attribute>
		</id-->
		
		<identifier xmlns="http://hl7.org/fhir">
		<value>
			<xsl:attribute name="value">
				<xsl:value-of select="../requestId"/>
			</xsl:attribute>
		</value>
		</identifier>
		
		<type xmlns="http://hl7.org/fhir">
			<xsl:attribute name="value">
				<xsl:value-of select="'collection'"/>
			</xsl:attribute>
		</type>
	</xsl:template>
	<!--  Top-level-Bundle End -->
	<!-- Entry Begin-->
	<xsl:template match="identity" mode="entryIds">
		<entry xmlns="http://hl7.org/fhir">
			<item>
				<reference>
					<xsl:attribute name="value">
						<xsl:value-of select="fn:concat('#', .)"/>
					</xsl:attribute>
				</reference>
			</item>
		</entry>
	</xsl:template>
	<!-- Entry End -->
	<!-- Entry Items Begin -->
	<xsl:template name="processEntryListItems">
		<xsl:param name="items">
	  </xsl:param>
		<xsl:for-each select="$items">
			<entry xmlns="http://hl7.org/fhir">
				<item>
					<reference>
						<xsl:attribute name="value">
							<xsl:value-of select="fn:concat('#',.)"/>
						</xsl:attribute>
					</reference>
				</item>
			</entry>
		</xsl:for-each>
	</xsl:template>
	<!-- Entry Items End -->
	<!-- formatID Begin-->
	<xsl:template name="formatID">
		<xsl:param name="position_index"/>
		<xsl:param name="defaultprovider"/>
		<xsl:choose>
			<xsl:when test="($defaultprovider = 'YES' )">
				<xsl:value-of select="fn:string-join( ('Default','_',$position_index),'')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="fn:string-join( ('',$position_index),'')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--formatID End-->
	<!-- Patients List Begin -->
	<xsl:template match="patients" mode="List">
		<!-- The template would handle the population of List in the root Bundle-->
		<id xmlns="http://hl7.org/fhir">
			<xsl:attribute name="value">
				<xsl:value-of select="'patient-appointments'"/>
			</xsl:attribute>
		</id>
		<!--xsl:apply-templates mode="AllergyIntolerance" select="intoleranceConditions"-->
		<xsl:apply-templates mode="patients_patient" select="patient">
		</xsl:apply-templates>
	</xsl:template>
	<!-- Patients List End-->
	<!-- Patient  Begin -->
	<xsl:template match="patient" mode="patients_patient">
		<xsl:apply-templates mode="patients_patient_appointments" select="appointments">
	</xsl:apply-templates>
	</xsl:template>
	<!-- Patient End -->
	<!-- Appointments Begin -->
	<xsl:template match="appointments" mode="patients_patient_appointments">
		<xsl:apply-templates mode="patients_patient_appointments_appointment" select="appointment">
	     </xsl:apply-templates>
	</xsl:template>
	<!-- Appointments End-->
	<!-- Appointment Begin -->
	<xsl:template match="appointment" mode="patients_patient_appointments_appointment">
		<contained xmlns="http://hl7.org/fhir">
			<Appointment>
				<xsl:if test="recordIdentifier/identity">
					<!--id>
						<xsl:attribute name="value">
							<xsl:value-of select="recordIdentifier/identity"/>
						</xsl:attribute>
					</id-->
				</xsl:if>
				<xsl:if test="recordUpdateTime/literal">
					<meta>
						<lastUpdated>
							<xsl:attribute name="value">
								<xsl:value-of select="loc_func:formatDateTime(recordUpdateTime/literal)"/>
							</xsl:attribute>
						</lastUpdated>
					</meta>
				</xsl:if>
				<xsl:call-template name="appointment_contained">
		 </xsl:call-template>
		 
		      <xsl:if test="recordIdentifier/namespaceId or recordIdentifier/identity">
				<identifier>
				    <xsl:if test="recordIdentifier/namespaceId">
					<system>
						<xsl:attribute name="value">
							<xsl:value-of select="recordIdentifier/namespaceId"/>
						</xsl:attribute>
					</system>
					</xsl:if>
					
					<xsl:if test="recordIdentifier/identity">
					<value>
						<xsl:attribute name="value">
							<xsl:value-of select="recordIdentifier/identity"/>
						</xsl:attribute>
					</value>
					</xsl:if>
	
				</identifier>
				</xsl:if>
				<status>
					<xsl:attribute name="value">
						<xsl:value-of select="if (appointmentStatus/code = 'NS' or appointmentStatus/code = 'NSR' ) then 
				'nowshow'
				else if (appointmentStatus/code = 'CP' or appointmentStatus/code = 'SPR' or appointmentStatus/code = 'CCR') then
				 'cancelled'
				 else if (appointmentStatus/code = 'R' ) then
				 'arrived'
				 else if(appointmentStatus/code = 'I' or appointmentStatus/code = 'NT') then
				 'booked'
				 else
				 ''
				"/>
					</xsl:attribute>
				</status>
				<serviceType>
					<text>
						<xsl:attribute name="value">
							<xsl:value-of select="service"/>
						</xsl:attribute>
					</text>
				</serviceType>
				<appointmentType>
					<coding>
						<code>
							<xsl:attribute name="value">
								<xsl:value-of select="appointmentType/code"/>
							</xsl:attribute>
						</code>
						<display>
							<xsl:attribute name="value">
								<xsl:value-of select="appointmentType/displayText"/>
							</xsl:attribute>
						</display>
					</coding>
				</appointmentType>
				<xsl:if test="ekgDateTime">
					<supportingInformation>
						<identifier>
							<xsl:attribute name="id">
								<xsl:value-of select="'ekg date time'"/>
							</xsl:attribute>
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="loc_func:formatDateTime(ekgDateTime/literal)"/>
								</xsl:attribute>
							</value>
						</identifier>
					</supportingInformation>
				</xsl:if>
				<xsl:if test="xrayDateTime">
					<supportingInformation>
						<identifier>
							<xsl:attribute name="id">
								<xsl:value-of select="'x-ray date time'"/>
							</xsl:attribute>
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="loc_func:formatDateTime(xrayDateTime/literal)"/>
								</xsl:attribute>
							</value>
						</identifier>
					</supportingInformation>
				</xsl:if>
				<xsl:if test="labDateTime">
					<supportingInformation>
						<identifier>
							<xsl:attribute name="id">
								<xsl:value-of select="'lab date time'"/>
							</xsl:attribute>
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="loc_func:formatDateTime(labDateTime/literal)"/>
								</xsl:attribute>
							</value>
						</identifier>
					</supportingInformation>
				</xsl:if>
				<xsl:if test="clinicMeetsAtThisFacility">
					<supportingInformation>
						<identifier>
							<xsl:attribute name="id">
								<xsl:value-of select="'Client Meets At This Facility Response'"/>
							</xsl:attribute>
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="clinicMeetsAtThisFacility"/>
								</xsl:attribute>
							</value>
						</identifier>
					</supportingInformation>
				</xsl:if>
				<xsl:if test="displayClinicApptToPatient">
					<supportingInformation>
						<identifier>
							<xsl:attribute name="id">
								<xsl:value-of select="'Display Clinic Appt To Patient Response'"/>
							</xsl:attribute>
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="displayClinicApptToPatient"/>
								</xsl:attribute>
							</value>
						</identifier>
					</supportingInformation>
				</xsl:if>
				<xsl:if test="allowDirectPatientScheduling">
					<supportingInformation>
						<identifier>
							<xsl:attribute name="id">
								<xsl:value-of select="'Allow Direct Patient Scheduling Response'"/>
							</xsl:attribute>
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="allowDirectPatientScheduling"/>
								</xsl:attribute>
							</value>
						</identifier>
					</supportingInformation>
				</xsl:if>
				<xsl:if test="telephoneExtension">
					<supportingInformation>
						<identifier>
							<xsl:attribute name="id">
								<xsl:value-of select="'Telephone Extension'"/>
							</xsl:attribute>
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="telephoneExtension"/>
								</xsl:attribute>
							</value>
						</identifier>
					</supportingInformation>
				</xsl:if>
				<xsl:if test="other">
					<supportingInformation>
						<identifier>
							<xsl:attribute name="id">
								<xsl:value-of select="'Other'"/>
							</xsl:attribute>
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="other"/>
								</xsl:attribute>
							</value>
						</identifier>
					</supportingInformation>
				</xsl:if>
				<xsl:if test="appointmentDateTime/literal">
					<start>
						<xsl:attribute name="value">
							<xsl:value-of select="loc_func:formatDateTime(appointmentDateTime/literal)"/>
						</xsl:attribute>
					</start>
				</xsl:if>
				<!--end>
				<xsl:attribute name="value">
					<xsl:value-of select="appointmentDateTime/literal"/>
				</xsl:attribute>
			</end-->
				<xsl:if test="location/identifier/identity">
					<participant>
						<actor>
							<reference>
								<xsl:attribute name="value">
									<xsl:value-of select="fn:concat('HospitalLocation/',location/identifier/identity)"/>
								</xsl:attribute>
							</reference>
						</actor>
						
						<status>
								<xsl:attribute name="value">
									<xsl:value-of select="'accepted'"/>
								</xsl:attribute>
						</status>
					</participant>
				</xsl:if>
				<xsl:if test="division">
					<participant>
						<actor>
							<reference>
								<xsl:attribute name="value">
									<xsl:value-of select="fn:concat('Division/',division)"/>
								</xsl:attribute>
							</reference>
						</actor>
						<status>
								<xsl:attribute name="value">
									<xsl:value-of select="'accepted'"/>
								</xsl:attribute>
						</status>
					</participant>
				</xsl:if>
				<xsl:if test="patient/identifier/identity">
					<participant>
						<actor>
							<reference>
								<xsl:attribute name="value">
									<xsl:value-of select="fn:concat('Patient/',patient/identifier/identity)"/>
								</xsl:attribute>
							</reference>
						</actor>
						<status>
								<xsl:attribute name="value">
									<xsl:value-of select="'accepted'"/>
								</xsl:attribute>
						</status>
					</participant>
				</xsl:if>
				<xsl:apply-templates mode="appointment_providers_provider_participant" select="provider">
	            </xsl:apply-templates>
			</Appointment>
		</contained>
	</xsl:template>
	<!-- Appointment End -->
	<xsl:template name="appointment_contained">
		<contained xmlns="http://hl7.org/fhir">
			<xsl:if test="location/institution/identifier/identity or location/institution/identifier/name or 
	        location/institution/shortName or location/institution/officialVAName">
				<Location>
					<xsl:if test="location/institution/identifier/identity">
						<identifier>
						  <value>
							<xsl:attribute name="value">
								<xsl:value-of select="location/institution/identifier/identity"/>
							</xsl:attribute>
							 </value>
						</identifier>
					</xsl:if>
					<xsl:if test="location/institution/identifier/name">
						<name>
							<xsl:attribute name="value">
								<xsl:value-of select="location/institution/identifier/name"/>
							</xsl:attribute>
						</name>
					</xsl:if>
					<xsl:if test="location/institution/shortName">
						<alias>
							<xsl:attribute name="value">
								<xsl:value-of select="location/institution/shortName"/>
							</xsl:attribute>
						</alias>
					</xsl:if>
					<xsl:if test="location.institution.officialVAName">
						<alias>
							<xsl:attribute name="value">
								<xsl:value-of select="location/institution/officialVAName"/>
							</xsl:attribute>
						</alias>
					</xsl:if>
					<description>
						<xsl:attribute name="value">
							<xsl:value-of select="'Institution'"/>
						</xsl:attribute>
					</description>
				</Location>
			</xsl:if>
		</contained>
		<contained xmlns="http://hl7.org/fhir">
			<xsl:if test="location/identifier/identity or location/identifier/name or locationPatientFriendlyName or location/telephone">
				<Location>
					<xsl:if test="location/identifier/identity">
						<identifier>
						 <value>
							<xsl:attribute name="value">
								<xsl:value-of select="location/identifier/identity"/>
							</xsl:attribute>
							</value>
						</identifier>
					</xsl:if>
					<xsl:if test="location/identifier/name">
						<name>
							<xsl:attribute name="value">
								<xsl:value-of select="location/identifier/name"/>
							</xsl:attribute>
						</name>
					</xsl:if>
					<xsl:if test="locationPatientFriendlyName">
						<alias>
							<xsl:attribute name="value">
								<xsl:value-of select="locationPatientFriendlyName"/>
							</xsl:attribute>
						</alias>
					</xsl:if>
					<description>
						<xsl:attribute name="value">
							<xsl:value-of select="'Hospital Location'"/>
						</xsl:attribute>
					</description>
					<xsl:if test="location/telephone">
						<telecom>
							<xsl:attribute name="id">
								<xsl:value-of select="location/telephone"/>
							</xsl:attribute>
						</telecom>
					</xsl:if>
					<xsl:if test="location/institution/identifier/identity">
						<partOf>
							<reference>
								<xsl:attribute name="value">
									<xsl:value-of select="fn:concat('#','Institution/',location/institution/identifier/identity)"/>
								</xsl:attribute>
							</reference>
						</partOf>
					</xsl:if>
				</Location>
			</xsl:if>
		</contained>
		<contained xmlns="http://hl7.org/fhir">
			<xsl:if test="division">
				<Location>
					<identifier>
					<value>
						<xsl:attribute name="value">
							<xsl:value-of select="division"/>
						</xsl:attribute>
						</value>
					</identifier>
					<name>
						<xsl:attribute name="value">
							<xsl:value-of select="division"/>
						</xsl:attribute>
					</name>
					<description>
						<xsl:attribute name="value">
							<xsl:value-of select="'Division'"/>
						</xsl:attribute>
					</description>
				</Location>
			</xsl:if>
		</contained>
		<contained xmlns="http://hl7.org/fhir">
			<xsl:if test="patient/identifier/identity or patient/identifier/identity or patient/identifier/assigningFacility or patient/name/displayName">
				<Patient>
					<xsl:if test="patient/identifier/identity">
						<id>
							<xsl:attribute name="value">
								<xsl:value-of select="patient/identifier/identity"/>
							</xsl:attribute>
						</id>
					</xsl:if>
					<xsl:if test="patient/identifier/identity or patient/identifier/assigningFacility">
						<identifier>
							<xsl:if test="patient/identifier/assigningFacility">
								<system>
									<xsl:attribute name="value">
										<xsl:value-of select="patient/identifier/assigningFacility"/>
									</xsl:attribute>
								</system>
							</xsl:if>
							<xsl:if test="patient/identifier/identity">
								<value>
									<xsl:attribute name="value">
										<xsl:value-of select="patient/identifier/identity"/>
									</xsl:attribute>
								</value>
							</xsl:if>
						
						</identifier>
					</xsl:if>
					<xsl:if test="patient/name/displayName">
						<name>
							<text>
								<xsl:attribute name="value">
									<xsl:value-of select="patient/name/displayName"/>
								</xsl:attribute>
							</text>
						</name>
					</xsl:if>
				</Patient>
			</xsl:if>
		</contained>
		<xsl:apply-templates mode="appointment_providers_provider" select="provider">
	    </xsl:apply-templates>
		
	</xsl:template>
	<!-- participants Begin -->
	<xsl:template match="provider" mode="appointment_providers_provider_participant">
		<xsl:variable name="ID_Index_1">
			<xsl:call-template name="formatID">
				<xsl:with-param name="position_index" select="position()">
                      </xsl:with-param>
				<xsl:with-param name="defaultprovider" select="default_provider">
                      </xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<participant xmlns="http://hl7.org/fhir">
			<actor>
				<reference>
					<xsl:attribute name="value">
						<xsl:value-of select="fn:concat('Practitioner/',$ID_Index_1)"/>
					</xsl:attribute>
				</reference>
			</actor>
		</participant>
	</xsl:template>
	<!-- participants End -->
	<!-- provider/Practitioner Begin -->
	<xsl:template match="provider" mode="appointment_providers_provider">
		<Practitioner xmlns="http://hl7.org/fhir">
			<xsl:variable name="Id_Index">
				<xsl:call-template name="formatID">
					<xsl:with-param name="position_index" select="position()">
                      </xsl:with-param>
					<xsl:with-param name="defaultprovider" select="default_provider">
                      </xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<id>
				<xsl:attribute name="value">
					<xsl:value-of select="$Id_Index"/>
				</xsl:attribute>
			</id>
			<name>
				<text>
					<xsl:attribute name="value">
						<xsl:value-of select="display_name"/>
					</xsl:attribute>
				</text>
				<family>
					<xsl:attribute name="value">
						<xsl:value-of select="name_family"/>
					</xsl:attribute>
				</family>
				<xsl:if test="name_given">
					<given>
						<xsl:attribute name="value">
							<xsl:value-of select="name_given"/>
						</xsl:attribute>
					</given>
				</xsl:if>
				<xsl:if test="name_middle">
					<given>
						<xsl:attribute name="value">
							<xsl:value-of select="name_middle"/>
						</xsl:attribute>
					</given>
				</xsl:if>
				<xsl:if test="name_title">
					<prefix>
						<xsl:attribute name="value">
							<xsl:value-of select="name_title"/>
						</xsl:attribute>
					</prefix>
				</xsl:if>
				<xsl:if test="name_prefix">
					<prefix>
						<xsl:attribute name="value">
							<xsl:value-of select="name_prefix"/>
						</xsl:attribute>
					</prefix>
				</xsl:if>
				<xsl:if test="name_suffix">
					<suffix>
						<xsl:attribute name="value">
							<xsl:value-of select="name_suffix"/>
						</xsl:attribute>
					</suffix>
				</xsl:if>
			</name>
		</Practitioner>
	</xsl:template>
	<!-- provider/Practitioner End -->
	<xsl:template match="patient" mode="Parameters">
		<!-- This template would handle the population of Parameters in the root Bundle-->
		<id xmlns="http://hl7.org/fhir">
			<xsl:attribute name="value">
				<xsl:value-of select="'requested-and-resolved-identifiers'"/>
			</xsl:attribute>
		</id>
		<xsl:apply-templates select="requestedNationalId">
		</xsl:apply-templates>
		<xsl:apply-templates select="requestedResolvedIdentifiers">
		</xsl:apply-templates>
		<xsl:apply-templates select="requestedExcludedIdentifiers">
		</xsl:apply-templates>
		<xsl:apply-templates select="resultantIdentifiers">
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="requestedNationalId">
		<!-- This template would handle the population of Parameters in the root Bundle-->
		<xsl:if test="self::node()">
			<parameter xmlns="http://hl7.org/fhir">
				<name>
					<xsl:attribute name="value">
						<xsl:value-of select="'requested-national-id'"/>
					</xsl:attribute>
				</name>
				<valueIdentifier>
					<value>
						<xsl:attribute name="value">
							<xsl:value-of select="."/>
						</xsl:attribute>
					</value>
				</valueIdentifier>
			</parameter>
		</xsl:if>
	</xsl:template>
	<!-- Begin -->
	<xsl:template match="requestedResolvedIdentifiers">
		<xsl:apply-templates select="requestedResolvedIdentifier">
	</xsl:apply-templates>
	</xsl:template>
	<!-- End -->
	<xsl:template match="requestedResolvedIdentifier">
		<!-- This template would handle the population of requestedResolvedIdentifiers in the root Parameters-->
		<xsl:if test="self::node()">
			<parameter xmlns="http://hl7.org/fhir">
				<name>
					<xsl:attribute name="value">
						<xsl:value-of select="'requested-resolved-identifier'"/>
					</xsl:attribute>
				</name>
				
				<xsl:if test="identity or assigningFacility or assigningAuthority">
				<valueIdentifier>
				   <xsl:if test="assigningFacility">
					<system>
						<xsl:attribute name="value">
							<xsl:value-of select="assigningFacility"/>
						</xsl:attribute>
					</system>
					</xsl:if>
					<xsl:if test="identity">
					<value>
						<xsl:attribute name="value">
							<xsl:value-of select="identity"/>
						</xsl:attribute>
					</value>
					</xsl:if>

                    <xsl:if test="assigningAuthority">
					<assigner>
						<identifier>
							<xsl:attribute name="id">
								<xsl:value-of select="assigningAuthority"/>
							</xsl:attribute>
						</identifier>
					</assigner>
					</xsl:if>
				</valueIdentifier>
				 </xsl:if>
			</parameter>
		</xsl:if>
	</xsl:template>
	<!-- Begin -->
	<xsl:template match="requestedExcludedIdentifiers">
		<xsl:apply-templates select="requestedExcludedIdentifier">
	</xsl:apply-templates>
	</xsl:template>
	<!-- End -->
	<xsl:template match="requestedExcludedIdentifier">
		<!-- This template would handle the population of requestedExcludedIdentifiers in the root Parameters-->
		<xsl:if test="self::node()">
			<parameter xmlns="http://hl7.org/fhir">
				<name>
					<xsl:attribute name="value">
						<xsl:value-of select="'requested-excluded-identifier'"/>
					</xsl:attribute>
				</name>
				
				<xsl:if test="identity or assigningFacility or assigningAuthority">
				<valueIdentifier>
				
				  <xsl:if test="assigningFacility">
				    <system>
						<xsl:attribute name="value">
							<xsl:value-of select="assigningFacility"/>
						</xsl:attribute>
					</system>
					</xsl:if>
					
					<xsl:if test="identity">
					<value>
						<xsl:attribute name="value">
							<xsl:value-of select="identity"/>
						</xsl:attribute>
					</value>
					</xsl:if>
					
					<xsl:if test="assigningAuthority">
					<assigner>
						<identifier>
							<xsl:attribute name="id">
								<xsl:value-of select="assigningAuthority"/>
							</xsl:attribute>
						</identifier>
					</assigner>
					</xsl:if>
				</valueIdentifier>
				</xsl:if>
			</parameter>
		</xsl:if>
	</xsl:template>
	<!-- Begin -->
	<xsl:template match="resultantIdentifiers">
		<xsl:apply-templates select="resultantIdentifier">
	</xsl:apply-templates>
	</xsl:template>
	<!-- End -->
	<xsl:template match="resultantIdentifier">
		<!-- This template would handle the population of resultantIdentifiers in the root Parameters-->
		<xsl:if test="self::node()">
			<parameter xmlns="http://hl7.org/fhir">
				<name>
					<xsl:attribute name="value">
						<xsl:value-of select="'resultant-identifier'"/>
					</xsl:attribute>
				</name>
				
				<xsl:if test="assigningFacility or identity or assigningAuthority">
				<valueIdentifier>
				
				  <xsl:if test="assigningFacility">
				   <system>
						<xsl:attribute name="value">
							<xsl:value-of select="assigningFacility"/>
						</xsl:attribute>
					</system>
					</xsl:if>
					
					<xsl:if test="identity">
					<value>
						<xsl:attribute name="value">
							<xsl:value-of select="identity"/>
						</xsl:attribute>
					</value>
					</xsl:if>
					
					<xsl:if test="assigningAuthority">
					<assigner>
						<identifier>
							<xsl:attribute name="id">
								<xsl:value-of select="assigningAuthority"/>
							</xsl:attribute>
						</identifier>
					</assigner>
					</xsl:if>
				</valueIdentifier>
				</xsl:if>
			</parameter>
		</xsl:if>
	</xsl:template>
	<!-- OperationOutcome Begin-->
	<xsl:template match="errorSection" mode="OperationOutcome">
		<!-- The template would handle the population of OperationalOutcome in the root Bundle-->
		<OperationOutcome xmlns="http://hl7.org/fhir">
			<xsl:if test="errors/errorId">
			
			   <xsl:if test="errors/errorId">
				<id>
					<xsl:attribute name="value">
						<xsl:value-of select="errors/errorId"/>
					</xsl:attribute>
				</id>
				</xsl:if>
			</xsl:if>
			<xsl:apply-templates select="errors">
		</xsl:apply-templates>
			<xsl:apply-templates select="fatalErrors">
		</xsl:apply-templates>
			<xsl:apply-templates select="warnings">
		</xsl:apply-templates>
		</OperationOutcome>
	</xsl:template>
	<!-- OperationOutcome End-->
	<!-- Begin -->
	<xsl:template match="warnings">
		<xsl:apply-templates select="warning">
	</xsl:apply-templates>
	</xsl:template>
	<!-- End -->
	<!-- warning Begin -->
	<xsl:template match="warning">
		<issue xmlns="http://hl7.org/fhir">
			<severity>
				<xsl:attribute name="value">
					<xsl:value-of select="'warning'"/>
				</xsl:attribute>
			</severity>
			<code>
				<xsl:attribute name="value">
					<xsl:value-of select="'exception'"/>
				</xsl:attribute>
			</code>
			
			<xsl:if test="errorId or displayMessage or exceptionMessage">
			<details>
			<xsl:if test="errorId or displayMessage">
				<coding>
				   <xsl:if test="errorId">
					<code>
						<xsl:attribute name="value">
							<xsl:value-of select="errorId"/>
						</xsl:attribute>
					</code>
					</xsl:if>
					<xsl:if test="displayMessage"> 
					<display>
						<xsl:attribute name="value">
							<xsl:value-of select="displayMessage"/>
						</xsl:attribute>
					</display>
					</xsl:if>
				</coding>
				</xsl:if>
				
				<xsl:if test="exceptionMessage"> 
				<text>
					<xsl:attribute name="value">
						<xsl:value-of select="exceptionMessage"/>
					</xsl:attribute>
				</text>
				</xsl:if>
			</details>
			</xsl:if>
			
			<xsl:if test="exception"> 
			<diagnostics>
				<xsl:attribute name="value">
					<xsl:value-of select="exception"/>
				</xsl:attribute>
			</diagnostics>
			</xsl:if>
		</issue>
	</xsl:template>
	<!-- warning End -->
	<!-- Begin -->
	<xsl:template match="errors">
		<xsl:apply-templates select="error">
	</xsl:apply-templates>
	</xsl:template>
	<!-- End -->
	<!-- errors Begin -->
	<xsl:template match="error">
		<issue xmlns="http://hl7.org/fhir">
			<severity>
				<xsl:attribute name="value">
					<xsl:value-of select="'error'"/>
				</xsl:attribute>
			</severity>
			<code>
				<xsl:attribute name="value">
					<xsl:value-of select="'exception'"/>
				</xsl:attribute>
			</code>
			
			<xsl:if test="errorId or displayMessage or exceptionMessage">
			<details>
			<xsl:if test="errorId or displayMessage"> 
				<coding>
					<code>
						<xsl:attribute name="value">
							<xsl:value-of select="errorId"/>
						</xsl:attribute>
					</code>
					<display>
						<xsl:attribute name="value">
							<xsl:value-of select="displayMessage"/>
						</xsl:attribute>
					</display>
				</coding>
				</xsl:if>
				
				<xsl:if test="exceptionMessage"> 
				<text>
					<xsl:attribute name="value">
						<xsl:value-of select="exceptionMessage"/>
					</xsl:attribute>
				</text>
				</xsl:if>
			</details>
			</xsl:if>
			<xsl:if test="exception">
			<diagnostics>
				<xsl:attribute name="value">
					<xsl:value-of select="exception"/>
				</xsl:attribute>
			</diagnostics>
			</xsl:if>
			
		</issue>
	</xsl:template>
	<!-- errors End -->
	<!-- Begin -->
	<xsl:template match="fatalErrors">
		<xsl:apply-templates select="fatalError">
	</xsl:apply-templates>
	</xsl:template>
	<!-- End -->
	<!-- fatal Errors Begin -->
	<xsl:template match="fatalError">
		<issue xmlns="http://hl7.org/fhir">
			<severity>
				<xsl:attribute name="value">
					<xsl:value-of select="'fatal'"/>
				</xsl:attribute>
			</severity>
			<code>
				<xsl:attribute name="value">
					<xsl:value-of select="'exception'"/>
				</xsl:attribute>
			</code>
			<xsl:if test="errorId or displayMessage or exceptionMessage "> 
			<details>
			    <xsl:if test="errorId or displayMessage"> 
				<coding>
				    <xsl:if test="errorId"> 
					<code>
						<xsl:attribute name="value">
							<xsl:value-of select="errorId"/>
						</xsl:attribute>
					</code>
					</xsl:if>
					
					<xsl:if test="displayMessage"> 
					<display>
						<xsl:attribute name="value">
							<xsl:value-of select="displayMessage"/>
						</xsl:attribute>
					</display>
					</xsl:if>
				</coding>
				</xsl:if>
				<xsl:if test="exceptionMessage"> 
				<text>
					<xsl:attribute name="value">
						<xsl:value-of select="exceptionMessage"/>
					</xsl:attribute>
				</text>
				</xsl:if>
			</details>
			</xsl:if>
			
			<xsl:if test="exception"> 
			<diagnostics>
				<xsl:attribute name="value">
					<xsl:value-of select="exception"/>
				</xsl:attribute>
			</diagnostics>
			</xsl:if>
		</issue>
	</xsl:template>
	<!-- fatal Errors End -->
</xsl:stylesheet>
