<?xml version="1.0" encoding="UTF-8"?>
<?altova_samplexml file:///C:/projects/Saxon/FHIR/data/VHIM_Allergy_Input_12_01_2017_akm.xml?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ns0="Clinicaldata" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:loc_func="http://www.DNS   /funcs" xmlns:fn="http://www.w3.org/2005/xpath-functions" exclude-result-prefixes="ns0 xs fn loc_func">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:variable name="var2_ClinicalData" as="node()?" select="ns0:ClinicalData"/>
	<!--xsl:function name="loc_func:date2timeStamp">
		<xsl:param name="dateString"/>
		<xsl:value-of select="( xs:dateTime($dateString) - xs:dateTime('1970-01-01T00:00:00') ) div xs:dayTimeDuration('PT1S')"/>
	</xsl:function-->
	<xsl:function name="loc_func:timeStamp_to_dateTime">
		<xsl:param name="timeStampString"/>
		<xsl:variable name="timezoneOffset">
			<xsl:choose>
				<xsl:when test="fn:contains($timeStampString, '-')">
					<xsl:value-of select="'-'"/>
				</xsl:when>
				<xsl:when test="fn:contains($timeStampString, '+')">
					<xsl:value-of select="'+'"/>
				</xsl:when>
				<xsl:otherwise>
       </xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="format" select="'[Y0001]-[M01]-[D01]T[H01]:[m01]:[s01][Z0000]'"/>
		<xsl:choose>
			<xsl:when test="fn:string-length($timezoneOffset) > 0">
				<xsl:variable name="dateTimeOnly" select="fn:substring-before($timeStampString,$timezoneOffset)"/>
				<xsl:choose>
					<xsl:when test="fn:string-length($dateTimeOnly) = 14">
						<xsl:variable name="timezone" select="fn:number(fn:substring(fn:substring-after($timeStampString,$timezoneOffset),1,2))"/>
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:variable name="timeString" select="fn:concat(fn:substring($timeStampString,9,2),':',fn:substring($timeStampString,11,2),':',fn:substring($timeStampString,13,2))"/>
						<xsl:value-of select="fn:concat($dateString,'T',$timeString,'.',$timezone,'00')"/>
					</xsl:when>
					<xsl:when test="fn:string-length($dateTimeOnly) = 12">
						<xsl:variable name="timezone" select="fn:number(fn:substring(fn:substring-after($timeStampString,$timezoneOffset),1,2))"/>
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:variable name="timeString" select="fn:concat(fn:substring($timeStampString,9,2),':',fn:substring($timeStampString,11,2),':00')"/>
						<xsl:value-of select="fn:concat($dateString,'T',$timeString,'.',$timezone,'00')"/>
					</xsl:when>
					<xsl:when test="fn:string-length( $dateTimeOnly) = 8">
						<xsl:variable name="timezone" select="fn:number(fn:substring(fn:substring-after($timeStampString,$timezoneOffset),1,2))"/>
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:variable name="timeString" select="fn:concat('00:00:00','')"/>
						<xsl:value-of select="fn:concat($dateString,'T',$timeString,'.',$timezone,'00')"/>
					</xsl:when>
					<xsl:otherwise>
						</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="fn:string-length($timeStampString) = 14">
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:variable name="timeString" select="fn:concat(fn:substring($timeStampString,9,2),':',fn:substring($timeStampString,11,2),':',
						 fn:substring($timeStampString,13,2))"/>
						<xsl:value-of select="fn:concat($dateString,'T',$timeString)"/>
					</xsl:when>
					<xsl:when test="fn:string-length($timeStampString ) = 12">
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:variable name="timeString" select="fn:concat(fn:substring($timeStampString,9,2),':',fn:substring($timeStampString,11,2))"/>
						<xsl:value-of select="fn:concat($dateString,'T',$timeString,':00')"/>
					</xsl:when>
					<xsl:when test="fn:string-length($timeStampString) = 8">
						<xsl:variable name="dateString" select="fn:concat(fn:substring($timeStampString,1,4),'-',fn:substring($timeStampString,5,2),'-',fn:substring($timeStampString,7,2))"/>
						<xsl:value-of select="fn:concat($dateString,'T','00:00:00')"/>
					</xsl:when>
					<xsl:otherwise>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:function>
	<!--xsl:template match="/"-->
	<xsl:template match="/">
		<Bundle xmlns="http://hl7.org/fhir" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
			<xsl:attribute name="xsi:schemaLocation">http://hl7.org/fhir http://hl7.org/fhir/fhir-single.xsd</xsl:attribute>
			<xsl:apply-templates mode="bundleTopElements" select="$var2_ClinicalData/patient">
		    </xsl:apply-templates>
			<xsl:choose>
				<xsl:when test="$var2_ClinicalData/patient/intoleranceConditions">
					<entry>
						<resource>
							<List>
								<xsl:apply-templates mode="List" select="$var2_ClinicalData/patient">
	                    </xsl:apply-templates>
								<status xmlns="http://hl7.org/fhir">
									<xsl:attribute name="value">
										<xsl:value-of select="'current'"/>
									</xsl:attribute>
								</status>
								<mode xmlns="http://hl7.org/fhir">
									<xsl:attribute name="value">
										<xsl:value-of select="'snapshot'"/>
									</xsl:attribute>
								</mode>
								<xsl:variable name="allergy_IC_IDs" select="$var2_ClinicalData/patient/intoleranceConditions/recordIdentifier/identity">
						</xsl:variable>
								<xsl:call-template name="processEntryListItems">
									<xsl:with-param name="items" select="$allergy_IC_IDs">
						</xsl:with-param>
								</xsl:call-template>
							</List>
						</resource>
					</entry>
				</xsl:when>
				<xsl:when test="$var2_ClinicalData/patient/allergyAssessments">
					<entry>
						<resource>
							<List>
								<xsl:apply-templates mode="List_for_Assessment" select="$var2_ClinicalData/patient">
	                            </xsl:apply-templates>
								<status xmlns="http://hl7.org/fhir">
									<xsl:attribute name="value">
										<xsl:value-of select="'current'"/>
									</xsl:attribute>
								</status>
								<mode xmlns="http://hl7.org/fhir">
									<xsl:attribute name="value">
										<xsl:value-of select="'snapshot'"/>
									</xsl:attribute>
								</mode>
								<xsl:variable name="allergy_AA_IDs" select="$var2_ClinicalData/patient/allergyAssessments/recordIdentifier/identity">
						        </xsl:variable>
								<xsl:call-template name="processEntryListItems">
									<xsl:with-param name="items" select="$allergy_AA_IDs">
						             </xsl:with-param>
								</xsl:call-template>
							</List>
						</resource>
					</entry>
				</xsl:when>
			</xsl:choose>
			<xsl:if test="$var2_ClinicalData/patient/requestedNationalId or $var2_ClinicalData/patient/requestedResolvedIdentifiers 
			or $var2_ClinicalData/patient/requestedExcludedIdentifiers or $var2_ClinicalData/patient/resultantIdentifiers">
				<entry>
					<resource>
						<Parameters>
							<xsl:apply-templates mode="Parameters" select="$var2_ClinicalData/patient">
				  </xsl:apply-templates>
						</Parameters>
					</resource>
				</entry>
			</xsl:if>
			<xsl:if test="$var2_ClinicalData/errorSection">
				<entry>
					<resource>
						<!--List-->
						<xsl:apply-templates mode="OperationOutcome" select="$var2_ClinicalData/errorSection">
	                    </xsl:apply-templates>
						<!--/List-->
					</resource>
				</entry>
			</xsl:if>
		</Bundle>
	</xsl:template>
	<xsl:template name="formatName">
		<xsl:param name="family_name"/>
		<xsl:param name="given_name"/>
		<xsl:param name="middle_name"/>
		<xsl:choose>
			<xsl:when test="($family_name != '' ) and ($given_name != '' ) and ($middle_name != '' )">
				<xsl:value-of select="fn:string-join( ($family_name,', ',$given_name,' ',$middle_name),'')"/>
			</xsl:when>
			<xsl:when test="($family_name != '') and ($given_name != '')">
				<xsl:value-of select="fn:string-join( ($family_name,', ',$given_name),'')"/>
			</xsl:when>
			<xsl:when test="($family_name != '') and ($middle_name != '' )">
				<xsl:value-of select="fn:string-join( ($family_name,', ',$middle_name),'')"/>
			</xsl:when>
			<xsl:when test="($family_name != '')">
				<xsl:value-of select="fn:string-join( ($family_name,''),'')"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="getAssessmentIndex">
		<xsl:param name="id">
	  </xsl:param>
		<xsl:param name="facility">
	  </xsl:param>
		<xsl:param name="auth">
	  </xsl:param>
		<xsl:variable name="theIndex">
			<xsl:for-each select="../allergyAssessments/patient">
				<xsl:if test="$id = identifier/identity and $auth = identifier/assigningAuthority and $facility = identifier/assigningFacility">
					<xsl:value-of select="position()">
		  </xsl:value-of>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="fn:string-length($theIndex) > 0">
				<xsl:value-of select="$theIndex"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'0'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="intoleranceConditions" mode="AllergyIntolerance">
		<!-- This template would handle the population of AllergyIntolerance in the root Bundle-->
		<contained xmlns="http://hl7.org/fhir">
			<AllergyIntolerance>
				<!--xsl:if test="recordIdentifier/identity">
					<id>
						<xsl:attribute name="value">
							<xsl:value-of select="recordIdentifier/identity"/>
						</xsl:attribute>
					</id>
				</xsl:if-->
				<xsl:if test="recordUpdateTime/literal">
					<meta>
						<lastUpdated>
							<xsl:attribute name="value">
								<!--xsl:value-of select="recordUpdateTime/literal"/-->
								<xsl:value-of select="loc_func:timeStamp_to_dateTime(recordUpdateTime/literal)"/>
							</xsl:attribute>
						</lastUpdated>
					</meta>
				</xsl:if>
				<xsl:if test="recordIdentifier/identity">
					<identifier>
						<value>
							<xsl:attribute name="value">
								<xsl:value-of select="recordIdentifier/identity"/>
							</xsl:attribute>
						</value>
					</identifier>
				</xsl:if>
				<verificationStatus>
					<xsl:attribute name="value">
						<xsl:value-of select="if (status = 'E' or status = 'EE') then 
				'entered-in-error'
				else if (status = 'F' ) then
				 'confirmed'
				 else
				 'unconfirmed'
				"/>
					</xsl:attribute>
				</verificationStatus>
				
				<xsl:if test="allergyType/code">
					<!--category>
						<xsl:attribute name="value">
							<xsl:value-of select="allergyType/code"/>
						</xsl:attribute>
					</category-->
					
				<category>
					<xsl:attribute name="value">
						<xsl:value-of select="if (allergyType/code = 'D' ) then 
				'medication'
				else if (allergyType/code = 'F' ) then
				 'food'
				 else
				 'biologic'
				"/>
					</xsl:attribute>
				</category>
					
					
				</xsl:if>
				
				<xsl:variable name="get_index">
					<xsl:call-template name="getAssessmentIndex">
						<xsl:with-param name="id" select="patient/identifier/identity">
                      </xsl:with-param>
						<xsl:with-param name="facility" select="patient/identifier/assigningFacility">
                      </xsl:with-param>
						<xsl:with-param name="auth" select="patient/identifier/assigningAuthority">
                      </xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="assessmentIndex" as="xs:integer">
					<xsl:value-of select="xs:integer($get_index)"/>
				</xsl:variable>
				<xsl:variable name="assessmentValue_codingSystem" select="$var2_ClinicalData/patient/allergyAssessments[$assessmentIndex]/assessmentValue/codingSystem">
						</xsl:variable>
				<xsl:variable name="assessmentValue_code" select="$var2_ClinicalData/patient/allergyAssessments[$assessmentIndex]/assessmentValue/code">
				</xsl:variable>
				<xsl:variable name="assessmentValue_displayText" select="$var2_ClinicalData/patient/allergyAssessments[$assessmentIndex]/assessmentValue/displayText">
				</xsl:variable>
				<xsl:if test="matches($assessmentValue_code,'4500630') and ($assessmentIndex > 0)">
					<code>
						<coding>
							<xsl:if test="fn:string-length($assessmentValue_codingSystem) > 0">
								<system>
									<xsl:attribute name="value">
										<xsl:value-of select="$assessmentValue_codingSystem"/>
									</xsl:attribute>
								</system>
							</xsl:if>
							<xsl:if test="fn:string-length($assessmentValue_code) > 0">
								<code>
									<xsl:attribute name="value">
										<xsl:value-of select="$assessmentValue_code"/>
									</xsl:attribute>
								</code>
							</xsl:if>
							<xsl:if test="fn:string-length($assessmentValue_displayText) > 0">
								<display>
									<xsl:attribute name="value">
										<xsl:value-of select="$assessmentValue_displayText"/>
									</xsl:attribute>
								</display>
							</xsl:if>
						</coding>
						<text>
							<xsl:attribute name="value">
								<xsl:value-of select="'NKA'"/>
							</xsl:attribute>
						</text>
					</code>
				</xsl:if>
				<xsl:if test="not(matches($assessmentValue_code,'4500630'))">
					<code>
						<xsl:if test="gmrAllergyAgent/code">
							<coding>
								<xsl:if test="gmrAllergyAgent/codingSystem">
									<system>
										<xsl:attribute name="value">
											<xsl:value-of select="gmrAllergyAgent/codingSystem"/>
										</xsl:attribute>
									</system>
								</xsl:if>
								<code>
									<xsl:attribute name="value">
										<xsl:value-of select="gmrAllergyAgent/code"/>
									</xsl:attribute>
								</code>
								<xsl:if test="gmrAllergyAgent/displayText">
									<display>
										<xsl:attribute name="value">
											<xsl:value-of select="gmrAllergyAgent/displayText"/>
										</xsl:attribute>
									</display>
								</xsl:if>
							</coding>
						</xsl:if>
						<xsl:if test="agent/code">
							<coding>
								<xsl:if test="agent/codingSystem">
									<system>
										<xsl:attribute name="value">
											<xsl:value-of select="agent/codingSystem"/>
										</xsl:attribute>
									</system>
								</xsl:if>
								<code>
									<xsl:attribute name="value">
										<xsl:value-of select="agent/code"/>
									</xsl:attribute>
								</code>
								<xsl:if test="agent/displayText">
									<display>
										<xsl:attribute name="value">
											<xsl:value-of select="agent/displayText"/>
										</xsl:attribute>
									</display>
								</xsl:if>
							</coding>
						</xsl:if>
					</code>
				</xsl:if>
				<patient>
					<xsl:if test="patient/identifier/assigningFacility or patient/identifier/identity or patient/identifier/assigningAuthority">
						<identifier>
							<xsl:if test="patient/identifier/assigningFacility">
								<system>
									<xsl:attribute name="value">
										<xsl:value-of select="patient/identifier/assigningFacility"/>
									</xsl:attribute>
								</system>
							</xsl:if>
							<xsl:if test="patient/identifier/identity">
								<value>
									<xsl:attribute name="value">
										<xsl:value-of select="patient/identifier/identity"/>
									</xsl:attribute>
								</value>
							</xsl:if>
							<xsl:if test="patient/identifier/assigningAuthority">
								<assigner>
									<identifier>
										<value>
											<xsl:attribute name="value">
												<xsl:value-of select="patient/identifier/assigningAuthority"/>
											</xsl:attribute>
										</value>
									</identifier>
								</assigner>
							</xsl:if>
						</identifier>
					</xsl:if>
					<xsl:variable name="fullname">
						<xsl:call-template name="formatName">
							<xsl:with-param name="family_name" select="patient/name/family">
                      </xsl:with-param>
							<xsl:with-param name="given_name" select="patient/name/given">
                      </xsl:with-param>
							<xsl:with-param name="middle_name" select="patient/name/middle">
                      </xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="patient/name/family or patient/name/given or patient/name/middle">
						<display>
							<xsl:attribute name="value">
								<xsl:value-of select="$fullname"/>
							</xsl:attribute>
						</display>
					</xsl:if>
				</patient>
				<xsl:if test="observationTime/literal">
					<assertedDate>
						<xsl:attribute name="value">
							<xsl:value-of select="loc_func:timeStamp_to_dateTime(observationTime/literal)"/>
						</xsl:attribute>
					</assertedDate>
				</xsl:if>
				<xsl:if test="author/practitioner/identifier/identity">
					<recorder>
						<identifier>
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="author/practitioner/identifier/identity"/>
								</xsl:attribute>
							</value>
						</identifier>
					</recorder>
				</xsl:if>
				<xsl:variable name="asserterE_EE_Status_Value" select="errorEnterer/practitioner/identifier/identity"/>
				<xsl:variable name="asserterF_Status_Value" select="verifier/practitioner/identifier/identity"/>
				<xsl:if test="errorEnterer/practitioner/identifier/identity or verifier/practitioner/identifier/identity or 
				errorEnterer/practitioner/name/family or verifier/practitioner/name/family">
					<asserter>
						<xsl:if test="errorEnterer/practitioner/identifier/identity or verifier/practitioner/identifier/identity">
							<identifier>
								<value>
									<xsl:attribute name="value">
										<xsl:value-of select="if (status = 'E' or status = 'EE') then 
				$asserterE_EE_Status_Value
				else if (status = 'F' ) then
				 $asserterF_Status_Value
				 else
				 ''
				"/>
									</xsl:attribute>
								</value>
							</identifier>
						</xsl:if>
						<xsl:variable name="practitioner">
							<xsl:call-template name="formatName">
								<xsl:with-param name="family_name" select="errorEnterer/practitioner/name/family">
                      </xsl:with-param>
								<xsl:with-param name="given_name" select="errorEnterer/practitioner/name/given">
                      </xsl:with-param>
								<xsl:with-param name="middle_name" select="errorEntererr/practitioner/name/middle">
                      </xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="verifier">
							<xsl:call-template name="formatName">
								<xsl:with-param name="family_name" select="verifier/practitioner/name/family">
                      </xsl:with-param>
								<xsl:with-param name="given_name" select="verifier/practitioner/name/given">
                      </xsl:with-param>
								<xsl:with-param name="middle_name" select="verifier/practitioner/name/middle">
                      </xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:if test="errorEnterer/practitioner/name/family or verifier/practitioner/name/family">
							<display>
								<xsl:attribute name="value">
									<xsl:value-of select="if (status = 'E' or status = 'EE') then 
				(: concat(errorEnterer/practitioner/name/family,', ',errorEnterer/practitioner/name/given,' ',errorEntererr/practitioner/name/middle) :)
				 $practitioner
				else if (status = 'F' ) then
				 (: concat(verifier/practitioner/name/family,', ',verifier/practitioner/name/given,' ',verifiererrorEntererr/practitioner/name/middle) :)
				 $verifier
				 else
				 ''
				"/>
								</xsl:attribute>
							</display>
						</xsl:if>
					</asserter>
				</xsl:if>
				<xsl:apply-templates select="commentEvents">
                 </xsl:apply-templates>
				<xsl:if test="reaction/reaction/codingSystem or reaction/reaction/code or reaction/reaction/displayText">
					<reaction>
						<manifestation>
							<coding>
								<xsl:if test="reaction/reaction/codingSystem">
									<system>
										<xsl:attribute name="value">
											<xsl:value-of select="reaction/reaction/codingSystem"/>
										</xsl:attribute>
									</system>
								</xsl:if>
								<xsl:if test="reaction/reaction/code">
									<code>
										<xsl:attribute name="value">
											<xsl:value-of select="reaction/reaction/code"/>
										</xsl:attribute>
									</code>
								</xsl:if>
								<xsl:if test="reaction/reaction/displayText">
									<display>
										<xsl:attribute name="value">
											<xsl:value-of select="reaction/reaction/displayText"/>
										</xsl:attribute>
									</display>
								</xsl:if>
							</coding>
						</manifestation>
					</reaction>
				</xsl:if>
			</AllergyIntolerance>
		</contained>
	</xsl:template>
	<xsl:template match="commentEvents">
		<xsl:if test="author/identifier/identity or comments or date/literal">
			<xsl:variable name="commentEventAuthor">
				<xsl:call-template name="formatName">
					<xsl:with-param name="family_name" select="author/name/family">
                      </xsl:with-param>
					<xsl:with-param name="given_name" select="author/name/given">
                      </xsl:with-param>
					<xsl:with-param name="middle_name" select="author/name/middle">
                      </xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<note xmlns="http://hl7.org/fhir">
				<xsl:if test="author/identifier/identity or (fn:string-length($commentEventAuthor) > 0) or (fn:string-length($commentEventAuthor) > 0)">
					<authorReference>
						<xsl:if test="author/identifier/identity">
							<identifier>
								<value>
									<xsl:attribute name="value">
										<xsl:value-of select="author/identifier/identity"/>
									</xsl:attribute>
								</value>
							</identifier>
						</xsl:if>
						<xsl:if test="fn:string-length($commentEventAuthor) > 0">
							<display>
								<xsl:attribute name="value">
									<xsl:value-of select="$commentEventAuthor"/>
								</xsl:attribute>
							</display>
						</xsl:if>
					</authorReference>
				</xsl:if>
				<xsl:if test="date/literal">
					<time>
						<xsl:attribute name="value">
							<xsl:value-of select="loc_func:timeStamp_to_dateTime(date/literal)"/>
						</xsl:attribute>
					</time>
				</xsl:if>
				<xsl:if test="comments">
					<text>
						<xsl:attribute name="value">
							<xsl:value-of select="comments"/>
						</xsl:attribute>
					</text>
				</xsl:if>
			</note>
		</xsl:if>
	</xsl:template>
	<xsl:template match="allergyAssessments" mode="Assessment">
		<!-- This template would handle the population of Allergy Assessments in the root Bundle-->
		<contained xmlns="http://hl7.org/fhir">
			<AllergyIntolerance>
				<!--id>
					<xsl:attribute name="value">
						<xsl:value-of select="recordIdentifier/identity"/>
					</xsl:attribute>
				</id-->
				<xsl:if test="recordUpdateTime/literal">
					<meta>
						<lastUpdated>
							<xsl:attribute name="value">
								<!--xsl:value-of select="recordUpdateTime/literal"/-->
								<xsl:value-of select="loc_func:timeStamp_to_dateTime(recordUpdateTime/literal)"/>
							</xsl:attribute>
						</lastUpdated>
					</meta>
				</xsl:if>
				<xsl:if test="recordIdentifier/identity">
					<identifier>
						<value>
							<xsl:attribute name="value">
								<xsl:value-of select="recordIdentifier/identity"/>
							</xsl:attribute>
						</value>
					</identifier>
				</xsl:if>
				<verificationStatus>
					<xsl:attribute name="value">
						<xsl:value-of select="if (status = 'E' or status = 'EE') then 
				'entered-in-error'
				else if (status = 'F' ) then
				 'confirmed'
				 else
				 'unconfirmed'
				"/>
					</xsl:attribute>
				</verificationStatus>
				<xsl:if test="assessmentValue/codingSystem or assessmentValue/code or assessmentValue/displayText">
					<code>
						<coding>
							<xsl:if test="assessmentValue/codingSystem">
								<system>
									<xsl:attribute name="value">
										<xsl:value-of select="assessmentValue/codingSystem"/>
									</xsl:attribute>
								</system>
							</xsl:if>
							<xsl:if test="assessmentValue/code">
								<code>
									<xsl:attribute name="value">
										<xsl:value-of select="assessmentValue/code"/>
									</xsl:attribute>
								</code>
							</xsl:if>
							<xsl:if test="assessmentValue/displayText">
								<display>
									<xsl:attribute name="value">
										<xsl:value-of select="assessmentValue/displayText"/>
									</xsl:attribute>
								</display>
							</xsl:if>
						</coding>
						<text>
							<xsl:attribute name="value">
								<xsl:value-of select="'NKA'"/>
							</xsl:attribute>
						</text>
					</code>
				</xsl:if>
				<patient>
					<xsl:if test="patient/identifier/assigningFacility or patient/identifier/identity or patient/identifier/assigningAuthority">
						<identifier>
							<system>
								<xsl:attribute name="value">
									<xsl:value-of select="patient/identifier/assigningFacility"/>
								</xsl:attribute>
							</system>
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="patient/identifier/identity"/>
								</xsl:attribute>
							</value>
							<assigner>
								<identifier>
									<value>
										<xsl:attribute name="value">
											<xsl:value-of select="patient/identifier/assigningAuthority"/>
										</xsl:attribute>
									</value>
								</identifier>
							</assigner>
						</identifier>
					</xsl:if>
					<xsl:variable name="fullname">
						<xsl:call-template name="formatName">
							<xsl:with-param name="family_name" select="patient/name/family">
                      </xsl:with-param>
							<xsl:with-param name="given_name" select="patient/name/given">
                      </xsl:with-param>
							<xsl:with-param name="middle_name" select="patient/name/middle">
                      </xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="fn:string-length($fullname ) > 0">
						<display>
							<xsl:attribute name="value">
								<!--xsl:value-of select="concat(patient/name/family,', ',patient/name/given,' ',patient/name/middle)"/-->
								<xsl:value-of select="$fullname"/>
							</xsl:attribute>
						</display>
					</xsl:if>
				</patient>
				<xsl:if test="observationTime/literal">
					<assertedDate>
						<xsl:attribute name="value">
							<xsl:value-of select="loc_func:timeStamp_to_dateTime(observationTime/literal)"/>
						</xsl:attribute>
					</assertedDate>
				</xsl:if>
				<xsl:if test="author/practitioner/identifier/identity">
					<recorder>
						<identifier>
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="author/practitioner/identifier/identity"/>
								</xsl:attribute>
							</value>
						</identifier>
					</recorder>
				</xsl:if>
				<xsl:variable name="asserterE_EE_Status_Value" select="errorEnterer/practitioner/identifier/identity"/>
				<xsl:variable name="asserterF_Status_Value" select="verifier/practitioner/identifier/identity"/>
				<xsl:if test="verifier.practitioner.identifier.identity">
					<asserter>
						<xsl:if test="errorEnterer/practitioner/identifier/identity or verifier/practitioner/identifier/identity">
							<identifier>
								<value>
									<xsl:attribute name="value">
										<xsl:value-of select="if (status = 'E' or status = 'EE') then 
				$asserterE_EE_Status_Value
				else if (status = 'F' ) then
				 $asserterF_Status_Value
				 else
				 ''
				"/>
									</xsl:attribute>
								</value>
							</identifier>
						</xsl:if>
						<xsl:variable name="practitioner">
							<xsl:call-template name="formatName">
								<xsl:with-param name="family_name" select="errorEnterer/practitioner/name/family">
                      </xsl:with-param>
								<xsl:with-param name="given_name" select="errorEnterer/practitioner/name/given">
                      </xsl:with-param>
								<xsl:with-param name="middle_name" select="errorEntererr/practitioner/name/middle">
                      </xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="verifier">
							<xsl:call-template name="formatName">
								<xsl:with-param name="family_name" select="verifier/practitioner/name/family">
                      </xsl:with-param>
								<xsl:with-param name="given_name" select="verifier/practitioner/name/given">
                      </xsl:with-param>
								<xsl:with-param name="middle_name" select="verifier/practitioner/name/middle">
                      </xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:if test="errorEnterer/practitioner/name/family or verifier/practitioner/name/family">
							<display>
								<xsl:attribute name="value">
									<xsl:value-of select="if (status = 'E' or status = 'EE') then 
				(: concat(errorEnterer/practitioner/name/family,', ',errorEnterer/practitioner/name/given,' ',errorEntererr/practitioner/name/middle) :)
				 $practitioner
				else if (status = 'F' ) then
				 (: concat(verifier/practitioner/name/family,', ',verifier/practitioner/name/given,' ',verifiererrorEntererr/practitioner/name/middle) :)
				 $verifier
				 else
				 ''
				"/>
								</xsl:attribute>
							</display>
						</xsl:if>
					</asserter>
				</xsl:if>
			</AllergyIntolerance>
		</contained>
	</xsl:template>
	<xsl:template match="patient" mode="Bundle">
		<!-- This template would handle the population of Bundle in the root Bundle-->
	</xsl:template>
	<xsl:template match="patient" mode="Parameters">
		<!-- This template would handle the population of Parameters in the root Bundle-->
		<id xmlns="http://hl7.org/fhir">
			<xsl:attribute name="value">
				<xsl:value-of select="'requested-and-resolved-identifiers'"/>
			</xsl:attribute>
		</id>
		<xsl:apply-templates select="requestedNationalId">
		</xsl:apply-templates>
		<xsl:apply-templates select="requestedResolvedIdentifiers">
		</xsl:apply-templates>
		<xsl:apply-templates select="requestedExcludedIdentifiers">
		</xsl:apply-templates>
		<xsl:apply-templates select="resultantIdentifiers">
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="requestedNationalId">
		<!-- This template would handle the population of Parameters in the root Bundle-->
		<xsl:if test="self::node()">
			<parameter xmlns="http://hl7.org/fhir">
				<name>
					<xsl:attribute name="value">
						<xsl:value-of select="'requested-national-id'"/>
					</xsl:attribute>
				</name>
				<valueIdentifier>
					<xsl:if test=".">
						<value>
							<xsl:attribute name="value">
								<xsl:value-of select="."/>
							</xsl:attribute>
						</value>
					</xsl:if>
				</valueIdentifier>
			</parameter>
		</xsl:if>
	</xsl:template>
	<xsl:template match="requestedResolvedIdentifiers">
		<!-- This template would handle the population of requestedResolvedIdentifiers in the root Parameters-->
		<xsl:if test="self::node()">
			<parameter xmlns="http://hl7.org/fhir">
				<name>
					<xsl:attribute name="value">
						<xsl:value-of select="'requested-resolved-identifiers'"/>
					</xsl:attribute>
				</name>
				<valueIdentifier>
					<xsl:if test="assigningFacility">
						<system>
							<xsl:attribute name="value">
								<xsl:value-of select="assigningFacility"/>
							</xsl:attribute>
						</system>
					</xsl:if>
					<xsl:if test="identity">
						<value>
							<xsl:attribute name="value">
								<xsl:value-of select="identity"/>
							</xsl:attribute>
						</value>
					</xsl:if>
					<xsl:if test="assigningAuthority">
						<assigner>
							<identifier>
								<xsl:attribute name="id">
									<xsl:value-of select="assigningAuthority"/>
								</xsl:attribute>
							</identifier>
						</assigner>
					</xsl:if>
				</valueIdentifier>
			</parameter>
		</xsl:if>
	</xsl:template>
	<xsl:template match="requestedExcludedIdentifiers">
		<!-- This template would handle the population of requestedExcludedIdentifiers in the root Parameters-->
		<xsl:if test="self::node()">
			<parameter xmlns="http://hl7.org/fhir">
				<name>
					<xsl:attribute name="value">
						<xsl:value-of select="'requested-excluded-identifiers'"/>
					</xsl:attribute>
				</name>
				<xsl:if test="assigningFacility or assigningFacility or identity or assigningAuthority">
					<valueIdentifier>
						<xsl:if test="assigningFacility">
							<system>
								<xsl:attribute name="value">
									<xsl:value-of select="assigningFacility"/>
								</xsl:attribute>
							</system>
						</xsl:if>
						<xsl:if test="identity">
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="identity"/>
								</xsl:attribute>
							</value>
						</xsl:if>
						<xsl:if test="assigningAuthority">
							<assigner>
								<identifier>
									<xsl:attribute name="id">
										<xsl:value-of select="assigningAuthority"/>
									</xsl:attribute>
								</identifier>
							</assigner>
						</xsl:if>
					</valueIdentifier>
				</xsl:if>
			</parameter>
		</xsl:if>
	</xsl:template>
	<xsl:template match="resultantIdentifiers">
		<!-- This template would handle the population of resultantIdentifiers in the root Parameters-->
		<xsl:if test="self::node()">
			<parameter xmlns="http://hl7.org/fhir">
				<name>
					<xsl:attribute name="value">
						<xsl:value-of select="'resultant-identifiers'"/>
					</xsl:attribute>
				</name>
				<xsl:if test="assigningFacility or identity or assigningAuthority">
					<valueIdentifier>
						<xsl:if test="assigningFacility">
							<system>
								<xsl:attribute name="value">
									<xsl:value-of select="assigningFacility"/>
								</xsl:attribute>
							</system>
						</xsl:if>
						<xsl:if test="identity">
							<value>
								<xsl:attribute name="value">
									<xsl:value-of select="identity"/>
								</xsl:attribute>
							</value>
						</xsl:if>
						<xsl:if test="assigningAuthority">
							<assigner>
								<identifier>
									<xsl:attribute name="id">
										<xsl:value-of select="assigningAuthority"/>
									</xsl:attribute>
								</identifier>
							</assigner>
						</xsl:if>
					</valueIdentifier>
				</xsl:if>
			</parameter>
		</xsl:if>
	</xsl:template>
	<xsl:template match="patient" mode="List">
		<!-- The template would handle the population of List in the root Bundle-->
		<id xmlns="http://hl7.org/fhir">
			<xsl:attribute name="value">
				<xsl:value-of select="'patient-allergy-intolerences'"/>
			</xsl:attribute>
		</id>
		<xsl:apply-templates mode="AllergyIntolerance" select="intoleranceConditions">
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="patient" mode="List_for_Assessment">
		<!-- The template would handle the population of List in the root Bundle-->
		<id xmlns="http://hl7.org/fhir">
			<xsl:attribute name="value">
				<xsl:value-of select="'patient-allergy-intolerences'"/>
			</xsl:attribute>
		</id>
		<xsl:apply-templates mode="Assessment" select="allergyAssessments">
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template name="processEntryListItems">
		<xsl:param name="items">
	  </xsl:param>
		<xsl:for-each select="$items">
			<entry xmlns="http://hl7.org/fhir">
				<item>
					<reference>
						<xsl:attribute name="value">
							<xsl:value-of select="."/>
						</xsl:attribute>
					</reference>
				</item>
			</entry>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="patient" mode="bundleTopElements">
		<xsl:if test="../requestId">
			<identifier xmlns="http://hl7.org/fhir">
				<value>
					<xsl:attribute name="value">
						<xsl:value-of select="../requestId"/>
					</xsl:attribute>
				</value>
			</identifier>
		</xsl:if>
		<type xmlns="http://hl7.org/fhir">
			<xsl:attribute name="value">
				<xsl:value-of select="'collection'"/>
			</xsl:attribute>
		</type>
	</xsl:template>
	<xsl:template match="errorSection" mode="OperationOutcome">
		<!-- The template would handle the population of OperationalOutcome in the root Bundle-->
		<OperationOutcome xmlns="http://hl7.org/fhir">
			<xsl:if test="errors/errorId">
				<id>
					<xsl:attribute name="value">
						<xsl:value-of select="errors/errorId"/>
					</xsl:attribute>
				</id>
			</xsl:if>
			<xsl:apply-templates select="errors">
		</xsl:apply-templates>
			<xsl:apply-templates select="fatalErrors">
		</xsl:apply-templates>
			<xsl:apply-templates select="warnings">
		</xsl:apply-templates>
		</OperationOutcome>
	</xsl:template>
	<xsl:template match="warnings">
		<issue xmlns="http://hl7.org/fhir">
			<severity>
				<xsl:attribute name="value">
					<xsl:value-of select="'warning'"/>
				</xsl:attribute>
			</severity>
			<code>
				<xsl:attribute name="value">
					<xsl:value-of select="'exception'"/>
				</xsl:attribute>
			</code>
			<details>
				<xsl:if test="errorId or displayMessage ">
					<coding>
						<xsl:if test="errorId">
							<code>
								<xsl:attribute name="value">
									<xsl:value-of select="errorId"/>
								</xsl:attribute>
							</code>
						</xsl:if>
						<xsl:if test="displayMessage">
							<display>
								<xsl:attribute name="value">
									<xsl:value-of select="displayMessage"/>
								</xsl:attribute>
							</display>
						</xsl:if>
					</coding>
				</xsl:if>
				<xsl:if test="exceptionMessage">
					<text>
						<xsl:attribute name="value">
							<xsl:value-of select="exceptionMessage"/>
						</xsl:attribute>
					</text>
				</xsl:if>
			</details>
			<xsl:if test="exception">
				<diagnostics>
					<xsl:attribute name="value">
						<xsl:value-of select="exception"/>
					</xsl:attribute>
				</diagnostics>
			</xsl:if>
		</issue>
	</xsl:template>
	<xsl:template match="errors">
		<issue xmlns="http://hl7.org/fhir">
			<severity>
				<xsl:attribute name="value">
					<xsl:value-of select="'error'"/>
				</xsl:attribute>
			</severity>
			<code>
				<xsl:attribute name="value">
					<xsl:value-of select="'exception'"/>
				</xsl:attribute>
			</code>
			<details>
				<xsl:if test="errorId or displayMessage or exceptionMessage">
					<coding>
						<code>
							<xsl:attribute name="value">
								<xsl:value-of select="errorId"/>
							</xsl:attribute>
						</code>
						<display>
							<xsl:attribute name="value">
								<xsl:value-of select="displayMessage"/>
							</xsl:attribute>
						</display>
					</coding>
				</xsl:if>
				<xsl:if test="exceptionMessage">
					<text>
						<xsl:attribute name="value">
							<xsl:value-of select="exceptionMessage"/>
						</xsl:attribute>
					</text>
				</xsl:if>
			</details>
			<xsl:if test="exception">
				<diagnostics>
					<xsl:attribute name="value">
						<xsl:value-of select="exception"/>
					</xsl:attribute>
				</diagnostics>
			</xsl:if>
		</issue>
	</xsl:template>
	<xsl:template match="fatalErrors">
		<issue xmlns="http://hl7.org/fhir">
			<severity>
				<xsl:attribute name="value">
					<xsl:value-of select="'fatal'"/>
				</xsl:attribute>
			</severity>
			<code>
				<xsl:attribute name="value">
					<xsl:value-of select="'exception'"/>
				</xsl:attribute>
			</code>
			<xsl:if test="errorId or displayMessage">
				<details>
					<xsl:if test="errorId or displayMessage or exceptionMessage">
						<coding>
							<xsl:if test="errorId">
								<code>
									<xsl:attribute name="value">
										<xsl:value-of select="errorId"/>
									</xsl:attribute>
								</code>
							</xsl:if>
							<xsl:if test="displayMessage">
								<display>
									<xsl:attribute name="value">
										<xsl:value-of select="displayMessage"/>
									</xsl:attribute>
								</display>
							</xsl:if>
						</coding>
					</xsl:if>
					<xsl:if test="exceptionMessage">
						<text>
							<xsl:attribute name="value">
								<xsl:value-of select="exceptionMessage"/>
							</xsl:attribute>
						</text>
					</xsl:if>
				</details>
			</xsl:if>
			<xsl:if test="exception">
				<diagnostics>
					<xsl:attribute name="value">
						<xsl:value-of select="exception"/>
					</xsl:attribute>
				</diagnostics>
			</xsl:if>
		</issue>
	</xsl:template>
	<xsl:template match="errors">
		<issue xmlns="http://hl7.org/fhir">
			<severity>
				<xsl:attribute name="value">
					<xsl:value-of select="'error'"/>
				</xsl:attribute>
			</severity>
			<code>
				<xsl:attribute name="value">
					<xsl:value-of select="'exception'"/>
				</xsl:attribute>
			</code>
			<xsl:if test="errorId or displayMessage or exceptionMessage">
				<details>
					<xsl:if test="errorId or displayMessage">
						<coding>
							<xsl:if test="errorId">
								<code>
									<xsl:attribute name="value">
										<xsl:value-of select="errorId"/>
									</xsl:attribute>
								</code>
							</xsl:if>
							<xsl:if test="displayMessage">
								<display>
									<xsl:attribute name="value">
										<xsl:value-of select="displayMessage"/>
									</xsl:attribute>
								</display>
							</xsl:if>
						</coding>
					</xsl:if>
					<xsl:if test="exceptionMessage">
						<text>
							<xsl:attribute name="value">
								<xsl:value-of select="exceptionMessage"/>
							</xsl:attribute>
						</text>
					</xsl:if>
				</details>
			</xsl:if>
			<xsl:if test="exception">
				<diagnostics>
					<xsl:attribute name="value">
						<xsl:value-of select="exception"/>
					</xsl:attribute>
				</diagnostics>
			</xsl:if>
		</issue>
	</xsl:template>
</xsl:stylesheet>
