

package gov.va.med.cds.filter;


import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.ExceptionHandler;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.response.ResponseAggregatorInterface;


public class MultipleIcnFilterHelper
{

    private static Log LOGGER = LogFactory.getLog( MultipleIcnFilterHelper.class );
    private static final String XPATH_SINGLE_PATIENT = "//patient";
    private static final String XPATH_ERROR_SECTION = "//errorSection";

    private Map<String, ResponseAggregatorInterface> multipleIcnResponseAggregator;


    public List<String> convertMultipleIcnFilterToSingleIcnFilter( String multipleIcnFilter )
    {

        List<String> singleIcnFilterList = new ArrayList<String>();
        List<Node> icnList = new ArrayList<Node>();

        Document multipleIcnFilterDocument = getDocument( multipleIcnFilter );

        Element patients = multipleIcnFilterDocument.getRootElement().element( "patients" );

        // Get the list of ICNS
        for ( Iterator iterator = ( Iterator )patients.elementIterator(); iterator.hasNext(); )
        {
            Element icn = ( Element )iterator.next();

            icnList.add( icn.detach() );
            LOGGER.debug( icn.getText() );
        }

        for ( Node icn : icnList )
        {
            // Generate Single ICN Filter
            String filterWithNoIcn = multipleIcnFilterDocument.asXML();

            // Create a new filter with ICN
            Document singleIcnFilter = getDocument( filterWithNoIcn );

            singleIcnFilter.getRootElement().element( "patients" ).add( icn );

            if ( LOGGER.isDebugEnabled() )
            {
                LOGGER.debug( singleIcnFilter.asXML() );
            }

            singleIcnFilterList.add( singleIcnFilter.asXML() );
        }

        return singleIcnFilterList;
    }


    public String retrieveICN( String singleFilter )
    {

        String singleIcn = null;

        try
        {
            Document singleIcnFilterDocument = getDocument( singleFilter );

            Element patients = singleIcnFilterDocument.getRootElement().element( "patients" );
            Element icn = patients.element( "NationalId" );

            singleIcn = icn.getText();
        }
        catch ( Exception ex )
        {

        }
        return singleIcn;
    }


    public Document mergeMultipleIcnResonse( List<Document> aMultipleIcnResponseDocuments, String aTemplateId )
    {
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( aMultipleIcnResponseDocuments.get( 0 ).asXML() );
        }

        Document mergedResponse = null;

        mergedResponse = multipleIcnResponseAggregator.get( aTemplateId ).aggregateResponses( aMultipleIcnResponseDocuments );

        // Remove unnecessary patient element without Non Veteran Info
        ( ( Node )mergedResponse.getRootElement().element( "patients" ).elements().get( 0 ) ).detach();

        return mergedResponse;
    }


    private Document getDocument( String filterRequest )
    {
        // Parse the input filter request XML
        try
        {
            return DocumentHelper.parseText( filterRequest );
        }
        catch ( DocumentException e )
        {
            throw new ValidationException( ErrorCodeEnum.FILTER_PARSER_DOM_EXCEPTION, e, filterRequest, e.getMessage() );
        }
    }


    public void setMultipleIcnResponseAggregator( Map<String, ResponseAggregatorInterface> multipleIcnResponseAggregator )
    {
        this.multipleIcnResponseAggregator = multipleIcnResponseAggregator;
    }


    public Document processException( Exception anException, String aTemplateId, String filterRequest, String filterId, String aRequestId,
                    String anAppName )
    {
        Document errorResponseDocument = null;

        try
        {
            errorResponseDocument = ExceptionHandler.handleException( anException, aTemplateId, aRequestId, anAppName );

            String requestedNationalICN = retrieveICN( filterRequest );
            if ( requestedNationalICN != null )
            {
                Element root = errorResponseDocument.getRootElement();
                Element patients = root.addElement( "patients" );
                Element patient = patients.addElement( "patient" );

                patient.addElement( "requestedNationalId" ).addText( requestedNationalICN );
                Element errorSection = ( Element )errorResponseDocument.selectSingleNode( XPATH_ERROR_SECTION );
                if ( errorSection != null )
                {
                    errorSection.detach();
                    patient.add( errorSection );
                   // errorSection.setParent( patient );
                    //patient.addElement( "displayMessage" ).addText( displayMessage.getText() );
                }
            }
        }
        catch ( Exception ex )
        {
            // ignore this top level exception since it was already logged and
            // we want to send info back to the
            // client
        }

        return errorResponseDocument;
    }
}
