

package gov.va.med.cds.filter;


import java.util.List;
import java.util.Set;

import org.dom4j.Element;

import gov.va.med.cds.common.person.correlation.PersonIdentifierInterface;


public interface CdsFilterInterface
{

    /**
     * Gets the filter XML.
     * @return The filter XML.
     */
    String getFilterXml( );


    /**
     * Gets the filter identifier
     * @return The filter identifier.
     */
    String getFilterId( );


    /**
     * Gets the unique request identifier.
     * @return the unique identifier.
     */
    String getUniqueIdentifier( );


    /**
     * Gets the entry point filters for this filter.
     * @return The entry point filters.
     */
    List<EntryFilterInterface> getEntryPointFilters( );


    /**
     * Gets the entry filter for a query.
     * @param queryName The query name to qualify the entry filter.
     * @return The entry filter.
     */
    EntryFilterInterface getEntryFilter( String queryName );


    /**
     * Gets the VHIM version of the filter.
     * @return The VHIM version.
     */
    String getVhimVersion( );


    /**
     * Gets the domain entry points for the filter.
     * @return The domain entry points.
     */
    Set<String> getDomainEntryPoints( );


    /**
     * Gets the list of person identifiers specified in the filter XML.
     * @return The list of person identifiers.
     */
    List<PersonIdentifierInterface> getPersonIdentifiers( );
    
    /**
     * Gets a list of elements that are the resolved corresponding indentifiers
     * of the nationalId minus the excludedIdentifiers
     * @return The list of resolved identifiers
     */
    List<Element> getResolvedIdentifiers( );


    /**
      * Gets the list of excluded identifiers specified in the filter - if any
      * @return The list of excluded identifiers
      */
    List<Element> getExcludedIdentifiers( );


    /**
     * Gets the nationaId specified in the filter
     * @return The nationalId
     */
    Element getNationalId( );
    
    /**
     * Gets EDIPI from the filter
     * @return edipi
     */
    public Element getEdipi( );
    
    boolean isPatientCentricFilter( );
    
    public void setSamlTokenAsString(String samlTokenAsString);
    
    public String getSamlTokenAsString();

}
