/**
 * 
 */


package gov.va.med.cds.client;


import gov.va.med.cds.exception.ClinicalDataServiceException;
import gov.va.med.cds.exception.ErrorCodeEnum;


public class ClinicalDataServiceProxy
    implements
        ClinicalDataServiceInterface
{

    private gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface proxy = null;


    public void setProxy( gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface proxy )
    {
        this.proxy = proxy;
    }


    public ClinicalDataServiceProxy( )
    {

    }


    public ClinicalDataServiceProxy( gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterface proxy )
    {
        this.proxy = proxy;
    }


    @Override
    public boolean isAlive( )
    {

        try
        {
            return proxy.isAlive();
        }
        catch ( Exception e )
        {
            throw new ClinicalDataServiceException( ErrorCodeEnum.CDS_SERVICE_EXCEPTION, e.getMessage() );
        }

    }


    @Override
    public String readClinicalData( String templateId, String filterRequest, String filterId, String requestId )
    {

        try
        {
            return proxy.readClinicalData( templateId, filterRequest, filterId, requestId );
        }
        catch ( Exception e )
        {
            throw new ClinicalDataServiceException( ErrorCodeEnum.CDS_SERVICE_EXCEPTION, e.getMessage() );
        }

    }


    @Override
    public String readClinicalData( String templateId, String filterId, String requestId )
    {

        try
        {
            return proxy.readClinicalData( templateId, filterId, requestId );
        }
        catch ( Exception e )
        {
            throw new ClinicalDataServiceException( ErrorCodeEnum.CDS_SERVICE_EXCEPTION, e.getMessage() );
        }

    }


    @Override
    public String createClinicalData( String createRequest, String templateId, String requestId )
    {
        try
        {
            return proxy.createClinicalData( createRequest, templateId, requestId );
        }
        catch ( Exception e )
        {
            throw new ClinicalDataServiceException( ErrorCodeEnum.CDS_SERVICE_EXCEPTION, e.getMessage() );
        }

    }


    @Override
    public String createClinicalData( String createRequest, String templateId, String requestId, boolean auditVhimRequest )
    {
        try
        {
            return proxy.createClinicalData( createRequest, templateId, requestId, auditVhimRequest );
        }
        catch ( Exception e )
        {
            throw new ClinicalDataServiceException( ErrorCodeEnum.CDS_SERVICE_EXCEPTION, e.getMessage() );
        }

    }


    @Override
    public String updateClinicalData( String updateRequest, String templateId, String requestId )
    {

        try
        {
            return proxy.updateClinicalData( updateRequest, templateId, requestId );
        }
        catch ( Exception e )
        {
            throw new ClinicalDataServiceException( ErrorCodeEnum.CDS_SERVICE_EXCEPTION, e.getMessage() );
        }

    }


    @Override
    public String deleteClinicalData( String deleteRequest, String templateId, String requestId )
    {

        try
        {
            return proxy.deleteClinicalData( deleteRequest, templateId, requestId );
        }
        catch ( Exception e )
        {
            throw new ClinicalDataServiceException( ErrorCodeEnum.CDS_SERVICE_EXCEPTION, e.getMessage() );
        }

    }


    @Override
    public String appendClinicalData( String appendRequest, String templateId, String requestId )
    {

        try
        {
            return proxy.appendClinicalData( appendRequest, templateId, requestId );
        }
        catch ( Exception e )
        {
            throw new ClinicalDataServiceException( ErrorCodeEnum.CDS_SERVICE_EXCEPTION, e.getMessage() );
        }

    }

}
