package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.requestresponse.generated.ReportIDType;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareSpringRunner;
import gov.va.med.cds.testharness.AbstractBaseTest;
import java.util.Map;
import javax.annotation.Resource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;

//import gov.va.med.cds.ars.requestresponse.generated.CensusPatientCountReportDataType;
//import gov.va.med.cds.ars.requestresponse.generated.CensusPatientCountReportFilterType;
//import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaType;
//import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
//import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
//import gov.va.med.cds.ars.requestresponse.generated.ObjectFactory;
//import javax.xml.datatype.DatatypeFactory;
//import javax.xml.datatype.XMLGregorianCalendar;

@RunWith(SuiteAwareSpringRunner.class)
@ContextConfiguration( locations = { 
                "/gov/va/med/cds/ars/config/nonWeblogicApplicationContext.xml", 
                "/gov/va/med/cds/ars/config/nonWeblogicHdrDataSourceContext.xml", 
				"/gov/va/med/cds/ars/config/exceptionHandlingConfigContext.xml",
				"/gov/va/med/cds/ars/config/filterContext.xml",
				"/gov/va/med/cds/ars/config/modelContext.xml",
				"/gov/va/med/cds/ars/config/jaxbContext.xml",
				"/gov/va/med/cds/ars/config/requestProcessorContext.xml" } )
                
public class CensusReadTest
    extends
        AbstractBaseTest
{
	
    private Map<String, ReadableReportsPersistenceManagerInterface> persistenceManagerMap = null;


    @Test
    @Suite( groups = { "checkintest" } )
    public void testPersistenceManagerMap( )
        throws Exception
    {
        Assert.assertNotNull( persistenceManagerMap );
    }
    
    @Test
    @Suite( groups = { "checkintest" } )
    public void testCensusReportConfiguration(){
    	ReadableReportsPersistenceManagerInterface persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get(ReportIDType.CENSUS_TOTAL_REPORT.value() );
    	Assert.assertNotNull(persistenceManager);
    	boolean b = (persistenceManager instanceof CensusPatientCountReportPersistenceManagerInterface ) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_DMPTOTAL_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusDMPCountReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_MEDDEVTOTAL_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusMedDevCountReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_IVRTOTAL_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusIVRCountReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_BROWSERTOTAL_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusBrowserCountReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_NOTASSIGNEDTOTAL_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusNotAssignedCountReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_MEASUREMENTTOTAL_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusMeasurementCountReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_VIDEOTOTAL_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusVideoCountReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_CELLMODEMTOTAL_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusCellCountReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_SATELLITETOTAL_REPORT.value());
    	Assert.assertNotNull(persistenceManager);
    	b = (persistenceManager instanceof CensusSatelliteCountReportPersistenceManagerInterface) ? true : false;
    	Assert.assertTrue(b);
    	
    	persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( ReportIDType.CENSUS_START_END_DATES_REPORT.value());
        Assert.assertNotNull(persistenceManager);
        b = (persistenceManager instanceof CensusStartEndDatesReportPersistenceManagerInterface) ? true : false;
        Assert.assertTrue(b);
    }
    
   /*
    private HTReportFilterType createCensusCountReportFilter(String reportType ) throws Exception {
   
    	ObjectFactory objectFactory = new ObjectFactory();
        HTReportFilterType htReportFilter = objectFactory.createHTReportFilterType();

        ReportIDType aReportType = ReportIDType.fromValue(reportType);
	    XMLGregorianCalendar startDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2014-04-27" );
	    XMLGregorianCalendar endDate = DatatypeFactory.newInstance().newXMLGregorianCalendar( "2014-05-03" );
	    String vendor = "200T1";
	    GeographicalAreaType geographicalArea = objectFactory.createGeographicalAreaType();
	    geographicalArea.setLocation("National");
	    
	    
		switch ( aReportType ) {
		
			case CENSUS_TOTAL_REPORT :
		        CensusPatientCountReportFilterType filter = objectFactory.createCensusPatientCountReportFilterType();
			    //filter.setReportID( aReportType );
		        filter.setReportID (ReportIDType.CENSUS_TOTAL_REPORT);
			    filter.setStartDate( startDate );
			    filter.setEndDate( endDate );
			    filter.setGeographicalArea(geographicalArea);
			    filter.setVendor(vendor);  
			    htReportFilter.setCensusPatientCountReportFilter (filter);
		    break;    
            default:
				break;
		}
	    return htReportFilter;
    }
    /*
    @Test
    @Suite( groups = { "checkintest" } )
    public void testCensusTotalReport( )
            throws Exception
    {
        HTReportFilterType reportFilter = createCensusCountReportFilter("CENSUS_TOTAL_REPORT");
                
        ReadableReportsPersistenceManagerInterface persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( "CENSUS_TOTAL_REPORT" );
        HTResponseType response = persistenceManager.performReadReportAggregate( reportFilter );
        CensusPatientCountReportDataType report = response.getCensusPatientCountReportData();
        ReportIDType reportID = report.getReportID();
        Assert.assertEquals( ReportIDType.CENSUS_TOTAL_REPORT, reportID );
        //List<GeographicalAreaVendorPatientCountDataType> recordsConsidered = report.getGeographicalAreaData();
       // Assert.assertNotNull( recordsConsidered );
    }
    
    */
    
    
   /* @Test
    @Suite( groups = { "checkintest" } )
    public void testCensusTotalReport( )
            throws Exception
    {
        HTReportFilterType reportFilter = createCensusCountReportFilter("CENSUS_START_END_DATES_REPORT");
                
        ReadableReportsPersistenceManagerInterface persistenceManager = ( ReadableReportsPersistenceManagerInterface )persistenceManagerMap.get( "CENSUS_START_END_DATES_REPORT" );
        HTResponseType response = persistenceManager.performReadReportAggregate( reportFilter );
        CensusPatientCountReportDataType report = response.getCensusPatientCountReportData();
        ReportIDType reportID = report.getReportID();
        Assert.assertEquals( ReportIDType.CENSUS_TOTAL_REPORT, reportID );
        //List<GeographicalAreaVendorPatientCountDataType> recordsConsidered = report.getGeographicalAreaData();
       // Assert.assertNotNull( recordsConsidered );
    }
    */
    
    @Resource
    public void setPersistenceManagerMap( Map<String, ReadableReportsPersistenceManagerInterface> aPersistenceManagerMap )
    {
        this.persistenceManagerMap = aPersistenceManagerMap;
    }
   
}
