

package gov.va.med.cds.ars.saml;


import gov.va.med.cds.saml.SamlAssertionThreadLocal;

import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;


/**
 * 
 * Class used to clean up any remaining data created/inserted by In Interceptors
 * - specifically content in ThreadLocal
 * 
 * @author DNS   TALBOM
 *
 */

public class CleanupOutInterceptor
    implements
        SOAPHandler<SOAPMessageContext>
{

    public void close( MessageContext messagecontext )
    {
    }


    public Set<QName> getHeaders( )
    {
        return null;
    }


    public boolean handleFault( SOAPMessageContext messagecontext )
    {
        return true;
    }


    public boolean handleMessage( SOAPMessageContext messagecontext )
    {
        if ( Boolean.TRUE.equals( messagecontext.get( MessageContext.MESSAGE_OUTBOUND_PROPERTY ) ) )
        {
            // cleanup ThreadLocal
            SamlAssertionThreadLocal.cleanup();
        }
        
        return true;
    }

}
