

package gov.va.med.cds.ars.persistence;


import gov.va.med.cds.ars.requestresponse.generated.DistributionLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.DistributionReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.DistributionReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;

import java.sql.Date;
import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;


public class DistributionReportsPersistenceManager
    extends
        AbstractReadableReportsPersistenceManager
    implements
        ReadableReportsPersistenceManagerInterface
{
    protected String distributionQuery = "SurveyReports.distribution";
    

    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
    {
    	DistributionReportFilterType filter = aReportFilter.getDistributionReportFilter();
        DistributionReportDataType data = new DistributionReportDataType();
        Session session = this.sessionFactory.getCurrentSession();
                
        try
        {
            List<DistributionLocationReportDataType> results = null;
            Integer surveyCount = null;
            
            results = distributionReport( session, filter );
            surveyCount = getSurveyCount( results );
            
            data.getReportData().addAll( results );
            data.setNumberOfRecordsConsidered( surveyCount );
            data.setReportID( filter.getReportID() );
        }
        finally
        {
            session.close();
        }
        
        responseType.setDistributionReportData( data );
        
        return responseType;
    }



    @SuppressWarnings( "unchecked" )
    private List<DistributionLocationReportDataType> distributionReport( Session aSession, DistributionReportFilterType aDistributionReportFilter )
        throws PersistenceException
    {
    	String surveyVersion = aDistributionReportFilter.getSurveyVersion();
        String surveyType = aDistributionReportFilter.getSurveyType() == null ? null : aDistributionReportFilter.getSurveyType().value();
        String location = aDistributionReportFilter.getGeographicalArea().getLocation();
        Date startDate = formatDate( aDistributionReportFilter.getStartDate() );
        Date endDate = formatDate( aDistributionReportFilter.getEndDate() );

        Query query = aSession.getNamedQuery( distributionQuery );
        query.setString( "surveyVersion", surveyVersion );
        query.setString( "surveyType", surveyType );
        query.setString( "location", location );
        query.setDate( "startDate", startDate );
        query.setDate( "endDate", endDate );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "+++++ Calling Distribution stored proc: *****(  " + distributionQuery + "  )*****" );
            LOGGER.debug( " surveyVersion: " + surveyVersion );
            LOGGER.debug( " surveyType: " + surveyType );
            LOGGER.debug( " location: " + location );
            LOGGER.debug( " startDate: " + startDate );
            LOGGER.debug( " endDate: " + endDate );
        }
        
        List<DistributionLocationReportDataType> results = ( List<DistributionLocationReportDataType> )queryForReportData( query );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "----- Done with Distribution stored proc" );
        }

        return results;
    }


    public void setDistributionQuery( String aDistributionQuery )
    {
        this.distributionQuery = aDistributionQuery;
    }

}

