

package gov.va.med.cds.ars.persistence;


import gov.va.med.cds.ars.requestresponse.generated.DMPTitleReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.DMPTitleReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.DMPTitleType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.ObjectFactory;
import gov.va.med.cds.exception.PersistenceException;

import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;


public class DMPTitleReportsPersistenceManager
    extends
        AbstractReadableReportsPersistenceManager
    implements
        ReadableReportsPersistenceManagerInterface
{
    protected String dMPTitlesQuery = "SurveyReports.DMPTitles";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
    {
        ObjectFactory objectFactory = new ObjectFactory();
        DMPTitleReportDataType data = objectFactory.createDMPTitleReportDataType();
        DMPTitleReportDataType.DmpTitles dmpTitles = objectFactory.createDMPTitleReportDataTypeDmpTitles();
        data.setDmpTitles( dmpTitles );
        DMPTitleReportFilterType filter = aReportFilter.getDMPTitleReportFilter();
        Session session = this.sessionFactory.getCurrentSession();     
        
        try
        {
            List<DMPTitleType> results = null;            
            results = dmpTitleReport( session, filter );

            data.getDmpTitles().getTitle().addAll( results );
            data.setReportID( filter.getReportID() );
        }
        finally
        {
            session.close();
        }
        
        responseType.setDMPTitleReportData( data );
        
        return responseType;
    }
    

    @SuppressWarnings( "unchecked" )
    private List<DMPTitleType> dmpTitleReport( Session aSession, DMPTitleReportFilterType aDMPTitleReportFilter )
        throws PersistenceException
    {        
        Query query = aSession.getNamedQuery( dMPTitlesQuery );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug("+++++ Calling DMP Titles stored proc: *****(  " + dMPTitlesQuery + "  )*****" );
        }
        
        List<DMPTitleType> results = ( List<DMPTitleType> )queryForReportData( query );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "----- Done with DMP Titles stored proc" );
        }

        return results;
    }


    public void setDMPTitlesQuery( String aDMPTitlesQuery )
    {
        this.dMPTitlesQuery = aDMPTitlesQuery;
    }

}

