package gov.va.med.cds.ars.persistence;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.query.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.CensusVideoPatientCountReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusVideoPatientCountReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;

public class CensusVideoCountReportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements CensusVideoCountReportPersistenceManagerInterface {
	
	protected String censusVideoCountReportQuery;
		
	@SuppressWarnings("unchecked")
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		CensusVideoPatientCountReportFilterType filter = aReportFilter.getCensusVideoPatientCountReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusVideoCountReportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusPatientCountReport query procedure: " + censusVideoCountReportQuery + " ======"  );
			        LOGGER.debug( " CensusPatientCountReport  startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusPatientCountReport  endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusPatientCountReport  geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusPatientCountReport  vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		CensusVideoPatientCountReportDataType data = new CensusVideoPatientCountReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setCensusVideoPatientCountReportData(data);
		
		return responseType;
		
	}

	public void setCensusVideoCountReportQuery(
			String aCensusVideoCountReportQuery){
		this.censusVideoCountReportQuery = aCensusVideoCountReportQuery;
	}

}
