package gov.va.med.cds.ars.persistence;


import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralVISNADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanVISNADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanVISNADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanVISNADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class CensusUrbanVISNADCReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    protected String hthUrbanVISNADCDataQuery = "SurveyReports.UrbanvisnAdcReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
	{
		CensusUrbanVISNADCReportFilterType filter = aReportFilter.getCensusUrbanVISNADCReportFilter();
		CensusUrbanVISNADCReportDataType data = new CensusUrbanVISNADCReportDataType();
		Session session = this.sessionFactory.getCurrentSession();
		List<CensusUrbanVISNADCLocationReportDataType> results = null;

		try {
			results = getUrbanVISNADCData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setCensusUrbanVISNADCReportData(data);

		return responseType;
	}    


    @SuppressWarnings("unchecked")
	private List<CensusUrbanVISNADCLocationReportDataType> getUrbanVISNADCData( Session aSession, CensusUrbanVISNADCReportFilterType censusReportFilter )
        throws PersistenceException
	{
		String location = censusReportFilter.getGeographicalArea().getLocation();
		Date startDate = formatDate(censusReportFilter.getStartDate());
		Date endDate = formatDate(censusReportFilter.getEndDate());
		
		Query query = aSession.getNamedQuery(hthUrbanVISNADCDataQuery);
		query.setString("location", location);
		query.setDate("startDate", startDate);
		query.setDate("endDate", endDate);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthUrbanVISNADCDataQuery + "  )*****");
			LOGGER.debug(" location: " + location);
			LOGGER.debug(" startDate: " + startDate);
			LOGGER.debug(" endDate: " + endDate);
		}

		List<CensusUrbanVISNADCLocationReportDataType> results = null;
		
		try {
			results = (List<CensusUrbanVISNADCLocationReportDataType>) queryForReportData(query);	
		} catch (Exception e) {
			LOGGER.error("Exception in getUrbanVISNADCData " + e);
		}

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc " + hthUrbanVISNADCDataQuery);
		}

		return results;
	}

    
    public void setHthUrbanVISNADCDataQuery(String hthUrbanVISNADCDataQuery) {
		this.hthUrbanVISNADCDataQuery = hthUrbanVISNADCDataQuery;
	}
}

