package gov.va.med.cds.ars.persistence;


import java.sql.Date;
import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanFacilityADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanFacilityADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUrbanFacilityADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class CensusUrbanFacilityADCReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    protected String hthUrbanFacilityADCDataQuery = "SurveyReports.UrbanFacilityADCReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
	{
		CensusUrbanFacilityADCReportFilterType filter = aReportFilter.getCensusUrbanFacilityADCReportFilter();
		CensusUrbanFacilityADCReportDataType data = new CensusUrbanFacilityADCReportDataType();
		Session session = this.sessionFactory.getCurrentSession();
		List<CensusUrbanFacilityADCLocationReportDataType> results = null;

		try {
			results = getUrbanFacilityADCData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setCensusUrbanFacilityADCReportData(data);

		return responseType;
	}    


	@SuppressWarnings("unchecked")
	private List<CensusUrbanFacilityADCLocationReportDataType> getUrbanFacilityADCData( Session aSession, CensusUrbanFacilityADCReportFilterType censusReportFilter )
        throws PersistenceException
	{
		String location = censusReportFilter.getGeographicalArea().getLocation();
		Date startDate = formatDate(censusReportFilter.getStartDate());
		Date endDate = formatDate(censusReportFilter.getEndDate());
		
		Query query = aSession.getNamedQuery(hthUrbanFacilityADCDataQuery);
		query.setString("location", location);
		query.setDate("startDate", startDate);
		query.setDate("endDate", endDate);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthUrbanFacilityADCDataQuery + "  )*****");
			LOGGER.debug(" location: " + location);
			LOGGER.debug(" startDate: " + startDate);
			LOGGER.debug(" endDate: " + endDate);
		}

		List<CensusUrbanFacilityADCLocationReportDataType> results = null;
		
		try {
			results = (List<CensusUrbanFacilityADCLocationReportDataType>) queryForReportData(query);	
		} catch (Exception e) {
			LOGGER.error("Exception in getUrbanFacilityADCData " + e);
		}

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc " + hthUrbanFacilityADCDataQuery);
		}

		return results;
	}

    
    public void setHthUrbanFacilityADCDataQuery(String hthUrbanFacilityADCDataQuery) {
		this.hthUrbanFacilityADCDataQuery = hthUrbanFacilityADCDataQuery;
	}
}

