package gov.va.med.cds.ars.persistence;


import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownVISNADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownVISNADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusUnknownVISNADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class CensusUnknownVISNADCReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    protected String hthUnknownVISNADCDataQuery = "SurveyReports.UnknownvisnAdcReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
	{
		CensusUnknownVISNADCReportFilterType filter = aReportFilter.getCensusUnknownVISNADCReportFilter();
		CensusUnknownVISNADCReportDataType data = new CensusUnknownVISNADCReportDataType();
		Session session = this.sessionFactory.getCurrentSession();
		List<CensusUnknownVISNADCLocationReportDataType> results = null;

		try {
			results = getUnknownVISNADCData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setCensusUnknownVISNADCReportData(data);

		return responseType;
	}    


	@SuppressWarnings("unchecked")
	private List<CensusUnknownVISNADCLocationReportDataType> getUnknownVISNADCData( Session aSession, CensusUnknownVISNADCReportFilterType censusReportFilter )
        throws PersistenceException
	{
		String location = censusReportFilter.getGeographicalArea().getLocation();
		Date startDate = formatDate(censusReportFilter.getStartDate());
		Date endDate = formatDate(censusReportFilter.getEndDate());
		
		Query query = aSession.getNamedQuery(hthUnknownVISNADCDataQuery);
		query.setString("location", location);
		query.setDate("startDate", startDate);
		query.setDate("endDate", endDate);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthUnknownVISNADCDataQuery + "  )*****");
			LOGGER.debug(" location: " + location);
			LOGGER.debug(" startDate: " + startDate);
			LOGGER.debug(" endDate: " + endDate);
		}

		List<CensusUnknownVISNADCLocationReportDataType> results = null;
		
		try {
			results = (List<CensusUnknownVISNADCLocationReportDataType>) queryForReportData(query);	
		} catch (Exception e) {
			LOGGER.error("Exception in getUnknownVISNADCData " + e);
		}

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc " + hthUnknownVISNADCDataQuery);
		}

		return results;
	}

    
    public void setHthUnknownVISNADCDataQuery(String hthUnknownVISNADCDataQuery) {
		this.hthUnknownVISNADCDataQuery = hthUnknownVISNADCDataQuery;
	}
}

