

package gov.va.med.cds.ars.persistence;


import gov.va.med.cds.ars.requestresponse.generated.CensusTransmittalModesReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusTransmittalModeReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusTransmittalModeReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.ObjectFactory;
import gov.va.med.cds.exception.PersistenceException;

import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;


public class CensusTransmittalModeReportPersistenceManager extends AbstractReadableReportsPersistenceManager
	implements CensusTransmittalModeReportPersistenceManagerInterface {
	
	protected String transmittalModeQuery = "SurveyReports.CensusTransmittalMode";
	                                         
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
    {
	   
        ObjectFactory objectFactory = new ObjectFactory();
        CensusTransmittalModesReportDataType data = objectFactory.createCensusTransmittalModesReportDataType();
        
        CensusTransmittalModesReportDataType.TransmittalModes transmittalModes = objectFactory.createCensusTransmittalModesReportDataTypeTransmittalModes();
        data.setTransmittalModes( transmittalModes );
        CensusTransmittalModeReportFilterType filter = aReportFilter.getCensusTransmittalModeReportFilter();
        Session session = this.sessionFactory.getCurrentSession();     
        
        try
        {
            
        	List<CensusTransmittalModeReportDataType> results = null; 
        	//List<String> results = null; 
            results = transmittalModeReport( session, filter );
            data.getTransmittalModes().getTransmittalMode().addAll( results );
            
            //data = results.get(0);
            data.setReportID( filter.getReportID() );
        }
        finally
        {
            session.close();
        }
        
        responseType.setCensusTransmittalModesReportData(data);
        
        return responseType;
        
    	/*
    	 CensusTransmittalModeReportFilterType filter =  aReportFilter.getCensusTransmittalModeReportFilter();
    	 Session session = this.sessionFactory.getCurrentSession(); 
    	 List<CensusTransmittalModeReportDataType> results = transmittalModeReport( session, filter );
    	 CensusTransmittalModesReportDataType data = new  CensusTransmittalModesReportDataType();
    	 CensusTransmittalModesReportDataType.TransmittalModes  TransmittalModes = new CensusTransmittalModesReportDataType.TransmittalModes();
    	 TransmittalModes.getTransmittalMode().addAll(results);
    	 data.setTransmittalModes(TransmittalModes);
    	 data.setReportID(filter.getReportID());
    	 responseType.setCensusTransmittalModesReportData(data);
    	 return responseType;*/
        
    }
    

    @SuppressWarnings( "unchecked" )
    private List<CensusTransmittalModeReportDataType> transmittalModeReport( Session aSession, CensusTransmittalModeReportFilterType aCensusTransmittalModeReportFilterType  )
        throws PersistenceException
    {        
        Query query = aSession.getNamedQuery( transmittalModeQuery );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug("+++++ Calling Census Transmittal Mode Repot stored proc: *****(  " + transmittalModeQuery + "  )*****" );
        }
        
       List<CensusTransmittalModeReportDataType> results = ( List<CensusTransmittalModeReportDataType> )queryForReportData( query );
        //List<String> results = ( List<String> )queryForReportData( query );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "----- Done with Census Vendor Report stored proc" );
        }

        return results;
    }


    public void setTransmittalModeQuery( String aTransmittalModeQuery  )
    {
        this.transmittalModeQuery=  aTransmittalModeQuery ;
    }
}

