package gov.va.med.cds.ars.persistence;


import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.CensusRuralVISNADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusRuralVISNADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusRuralVISNADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.CensusTotalRuralVISNADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class CensusRuralVISNADCReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    protected String hthRuralVISNADCDataQuery = "SurveyReports.RuralvisnAdcReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
	{
		CensusRuralVISNADCReportFilterType filter = aReportFilter.getCensusRuralVISNADCReportFilter();
		CensusRuralVISNADCReportDataType data = new CensusRuralVISNADCReportDataType();
		Session session = this.sessionFactory.getCurrentSession();
		List<CensusRuralVISNADCLocationReportDataType> results = null;

		try {
			results = getRuralVISNADCData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setCensusRuralVISNADCReportData(data);

		return responseType;
	}    


    @SuppressWarnings("unchecked")
	private List<CensusRuralVISNADCLocationReportDataType> getRuralVISNADCData( Session aSession, CensusRuralVISNADCReportFilterType censusReportFilter )
        throws PersistenceException
	{
		String location = censusReportFilter.getGeographicalArea().getLocation();
		Date startDate = formatDate(censusReportFilter.getStartDate());
		Date endDate = formatDate(censusReportFilter.getEndDate());
		
		Query query = aSession.getNamedQuery(hthRuralVISNADCDataQuery);
		query.setString("location", location);
		query.setDate("startDate", startDate);
		query.setDate("endDate", endDate);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthRuralVISNADCDataQuery + "  )*****");
			LOGGER.debug(" location: " + location);
			LOGGER.debug(" startDate: " + startDate);
			LOGGER.debug(" endDate: " + endDate);
		}

		List<CensusRuralVISNADCLocationReportDataType> results = null;
		
		try {
			results = (List<CensusRuralVISNADCLocationReportDataType>) queryForReportData(query);	
		} catch (Exception e) {
			LOGGER.error("Exception in getRuralVISNADCData " + e);
		}
		
		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc " + hthRuralVISNADCDataQuery);
		}

		return results;
	}

    
    public void setHthRuralVISNADCDataQuery(String hthRuralVISNADCDataQuery) {
		this.hthRuralVISNADCDataQuery = hthRuralVISNADCDataQuery;
	}
}

