package gov.va.med.cds.ars.persistence;


import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.CensusRuralFacilityADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusRuralFacilityADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusRuralFacilityADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class CensusRuralFacilityADCReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    protected String hthRuralFacilityADCDataQuery = "SurveyReports.RuralfacilityAdcReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
	{
		CensusRuralFacilityADCReportFilterType filter = aReportFilter.getCensusRuralFacilityADCReportFilter();
		CensusRuralFacilityADCReportDataType data = new CensusRuralFacilityADCReportDataType();
		Session session = this.sessionFactory.getCurrentSession();
		List<CensusRuralFacilityADCLocationReportDataType> results = null;

		try {
			results = getRuralFacilityADCData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setCensusRuralFacilityADCReportData(data);

		return responseType;
	}    


    @SuppressWarnings( "unchecked" )
    private List<CensusRuralFacilityADCLocationReportDataType> getRuralFacilityADCData( Session aSession, CensusRuralFacilityADCReportFilterType censusReportFilter )
        throws PersistenceException
	{
		String location = censusReportFilter.getGeographicalArea().getLocation();
		Date startDate = formatDate(censusReportFilter.getStartDate());
		Date endDate = formatDate(censusReportFilter.getEndDate());
		
		Query query = aSession.getNamedQuery(hthRuralFacilityADCDataQuery);
		query.setString("location", location);
		query.setDate("startDate", startDate);
		query.setDate("endDate", endDate);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthRuralFacilityADCDataQuery + "  )*****");
			LOGGER.debug(" location: " + location);
			LOGGER.debug(" startDate: " + startDate);
			LOGGER.debug(" endDate: " + endDate);
		}

		List<CensusRuralFacilityADCLocationReportDataType> results = null;
		
		try {
			results = (List<CensusRuralFacilityADCLocationReportDataType>) queryForReportData(query);	
		} catch (Exception e) {
			LOGGER.error("Exception in getRuralFacilityADCData " + e);
		}

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc " + hthRuralFacilityADCDataQuery);
		}

		return results;
	}

    
    public void setHthRuralFacilityADCDataQuery(String hthRuralFacilityADCDataQuery) {
		this.hthRuralFacilityADCDataQuery = hthRuralFacilityADCDataQuery;
	}
}

