package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalUnkRespReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalUnkRespReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.query.Query;
import org.hibernate.Session;

public class CensusRrTotalUnkRespRportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements ReadableReportsPersistenceManagerInterface {
	
	protected String censusRrTotalUnkRespRportQuery;
		
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		RRTotalUnkRespReportFilterType filter = aReportFilter.getRRTotalUnkRespReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusRrTotalUnkRespRportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusRRTotalUnkRespRportQuery query procedure: " + censusRrTotalUnkRespRportQuery + " ======"  );
			        LOGGER.debug( " CensusRRTotalUnkRespRport   startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusRRTotalUnkRespRport   endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusRRTotalUnkRespRport   geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusRRTotalUnkRespRport   vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		RRTotalUnkRespReportDataType data = new RRTotalUnkRespReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setRRTotalUnkRespReportData(data);
		
		return responseType;
		
	}

	public void setcensusRrTotalUnkRespRportQuery(
			String acensusRrTotalUnkRespRportQuery){
		this.censusRrTotalUnkRespRportQuery = acensusRrTotalUnkRespRportQuery;
	}

}
