package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalNonRespReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.RRTotalNonRespReportFilterType;
import gov.va.med.cds.exception.PersistenceException;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.query.Query;
import org.hibernate.Session;

public class CensusRrTotalNonRespRportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements ReadableReportsPersistenceManagerInterface {
	
	protected String censusRrTotalNonRespRportQuery;
		
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		RRTotalNonRespReportFilterType filter = aReportFilter.getRRTotalNonRespReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusRrTotalNonRespRportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusRRTotalNonRespRportQuery query procedure: " + censusRrTotalNonRespRportQuery + " ======"  );
			        LOGGER.debug( " CensusRRTotalNonRespRport   startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusRRTotalNonRespRport   endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusRRTotalNonRespRport   geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusRRTotalNonRespRport   vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		RRTotalNonRespReportDataType data = new RRTotalNonRespReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setRRTotalNonRespReportData(data);
		
		return responseType;
		
	}

	public void setcensusRrTotalNonRespRportQuery(
			String acensusRrTotalNonRespRportQuery){
		this.censusRrTotalNonRespRportQuery = acensusRrTotalNonRespRportQuery;
	}

}
