package gov.va.med.cds.ars.persistence;


import java.sql.Date;
import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.CensusNICADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusNICADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusNICADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class CensusNICADCReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    protected String hthNICADCDataQuery = "CensusReports.NicAdcReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
	{
		CensusNICADCReportFilterType filter = aReportFilter.getCensusNICADCReportFilter();
		CensusNICADCReportDataType data = new CensusNICADCReportDataType();
		Session session = this.sessionFactory.getCurrentSession();
		List<CensusNICADCLocationReportDataType> results = null;

		try {
			results = getCensusNICADCData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setCensusNICADCReportData(data);

		return responseType;
	}    


    @SuppressWarnings( "unchecked" )
    private List<CensusNICADCLocationReportDataType> getCensusNICADCData( Session aSession, CensusNICADCReportFilterType censusReportFilter )
        throws PersistenceException
	{
		String location = censusReportFilter.getGeographicalArea().getLocation();
		String timePeriod = censusReportFilter.getTimePeriod().value();
		Date startDate = formatDate(censusReportFilter.getStartDate());
		Date endDate = formatDate(censusReportFilter.getEndDate());
		
		Query query = aSession.getNamedQuery(hthNICADCDataQuery);
		query.setString("location", location);
		query.setDate("startDate", startDate);
		query.setDate("endDate", endDate);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthNICADCDataQuery + "  )*****");
			LOGGER.debug(" location: " + location);
			LOGGER.debug(" timePeriod: " + timePeriod);
			LOGGER.debug(" startDate: " + startDate);
			LOGGER.debug(" endDate: " + endDate);
		}

		List<CensusNICADCLocationReportDataType> results = null;

		try {
			results = (List<CensusNICADCLocationReportDataType>) queryForReportData(query);	
		} catch (Exception e) {
			LOGGER.error("Exception in getCensusNICADCData " + e);
		}
		
		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc : " + hthNICADCDataQuery);
		}

		return results;
	}

    
    public void setHthNICADCDataQuery(String hthNICADCDataQuery) {
		this.hthNICADCDataQuery = hthNICADCDataQuery;
	}
}

