package gov.va.med.cds.ars.persistence;


import java.sql.Date;
import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralVISNADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralVISNADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralVISNADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class CensusHighlyRuralVISNADCReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    protected String hthHighlyRuralVISNADCDataQuery = "SurveyReports.HighlyruralvisnAdcReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
	{
		CensusHighlyRuralVISNADCReportFilterType filter = aReportFilter.getCensusHighlyRuralVISNADCReportFilter();
		CensusHighlyRuralVISNADCReportDataType data = new CensusHighlyRuralVISNADCReportDataType();
		Session session = this.sessionFactory.getCurrentSession();
		List<CensusHighlyRuralVISNADCLocationReportDataType> results = null;

		try {
			results = getHighlyRuralVISNADCData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setCensusHighlyRuralVISNADCReportData(data);

		return responseType;
	}    


    @SuppressWarnings("unchecked")
	private List<CensusHighlyRuralVISNADCLocationReportDataType> getHighlyRuralVISNADCData( Session aSession, CensusHighlyRuralVISNADCReportFilterType censusReportFilter )
        throws PersistenceException
	{
		String location = censusReportFilter.getGeographicalArea().getLocation();
		Date startDate = formatDate(censusReportFilter.getStartDate());
		Date endDate = formatDate(censusReportFilter.getEndDate());
		
		Query query = aSession.getNamedQuery(hthHighlyRuralVISNADCDataQuery);
		query.setString("location", location);
		query.setDate("startDate", startDate);
		query.setDate("endDate", endDate);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthHighlyRuralVISNADCDataQuery + "  )*****");
			LOGGER.debug(" location: " + location);
			LOGGER.debug(" startDate: " + startDate);
			LOGGER.debug(" endDate: " + endDate);
		}

		List<CensusHighlyRuralVISNADCLocationReportDataType> results = null;
		
		try {
			results = (List<CensusHighlyRuralVISNADCLocationReportDataType>) queryForReportData(query);	
		} catch (Exception e) {
			LOGGER.error("Exception in getHighlyRuralVISNADCData " + e);
		}
		
		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc " + hthHighlyRuralVISNADCDataQuery);
		}

		return results;
	}

    
    public void setHthHighlyRuralVISNADCDataQuery(String hthHighlyRuralVISNADCDataQuery) {
		this.hthHighlyRuralVISNADCDataQuery = hthHighlyRuralVISNADCDataQuery;
	}
}

