package gov.va.med.cds.ars.persistence;


import java.sql.Date;
import java.util.List;

import org.hibernate.query.Query;
import org.hibernate.Session;

import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralFacilityADCLocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralFacilityADCReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.CensusHighlyRuralFacilityADCReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;


public class CensusHighlyRuralFacilityADCReportPersistenceManager
    extends AbstractReadableReportsPersistenceManager
    implements ReadableReportsPersistenceManagerInterface
{
    protected String hthHighlyRuralFacilityADCDataQuery = "SurveyReports.HighlyruralfacilityAdcReport";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
	{
		CensusHighlyRuralFacilityADCReportFilterType filter = aReportFilter.getCensusHighlyRuralFacilityADCReportFilter();
		CensusHighlyRuralFacilityADCReportDataType data = new CensusHighlyRuralFacilityADCReportDataType();
		Session session = this.sessionFactory.getCurrentSession();
		List<CensusHighlyRuralFacilityADCLocationReportDataType> results = null;

		try {
			results = getHighlyRuralFacilityADCData(session, filter);

			data.getReportData().addAll(results);
			data.setReportID(filter.getReportID());
		} finally {
			session.close();
		}

		responseType.setCensusHighlyRuralFacilityADCReportData(data);

		return responseType;
	}    


    @SuppressWarnings("unchecked")
	private List<CensusHighlyRuralFacilityADCLocationReportDataType> getHighlyRuralFacilityADCData( Session aSession, CensusHighlyRuralFacilityADCReportFilterType censusReportFilter )
        throws PersistenceException
	{
		String location = censusReportFilter.getGeographicalArea().getLocation();
		Date startDate = formatDate(censusReportFilter.getStartDate());
		Date endDate = formatDate(censusReportFilter.getEndDate());
		
		Query query = aSession.getNamedQuery(hthHighlyRuralFacilityADCDataQuery);
		query.setString("location", location);
		query.setDate("startDate", startDate);
		query.setDate("endDate", endDate);

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("+++++ Calling stored proc: *****(  " + hthHighlyRuralFacilityADCDataQuery + "  )*****");
			LOGGER.debug(" location: " + location);
			LOGGER.debug(" startDate: " + startDate);
			LOGGER.debug(" endDate: " + endDate);
		}

		List<CensusHighlyRuralFacilityADCLocationReportDataType> results = null;
		
		try {
			results = (List<CensusHighlyRuralFacilityADCLocationReportDataType>) queryForReportData(query);	
		} catch (Exception e) {
			LOGGER.error("Exception in getHighlyRuralFacilityADCData " + e);
		}

		if (LOGGER.isDebugEnabled()) {
			LOGGER.debug("----- Done with stored proc " + hthHighlyRuralFacilityADCDataQuery);
		}

		return results;
	}

    
    public void setHthHighlyRuralFacilityADCDataQuery(String hthHighlyRuralFacilityADCDataQuery) {
		this.hthHighlyRuralFacilityADCDataQuery = hthHighlyRuralFacilityADCDataQuery;
	}
}

