package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtHPDPReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtHPDPReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.query.Query;
import org.hibernate.Session;

public class CensusCoCTotalPtHPDPReportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements ReadableReportsPersistenceManagerInterface {
	
	protected String censusCoCTotalPtHPDPReportQuery;
		
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		COCTotalPtHPDPReportFilterType filter = aReportFilter.getCoCTotalPtHPDPReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusCoCTotalPtHPDPReportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusCoCTotalPtHPDPReport query procedure: " + censusCoCTotalPtHPDPReportQuery + " ======"  );
			        LOGGER.debug( " CensusCoCTotalPtHPDPReport   startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusCoCTotalPtHPDPReport   endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusCoCTotalPtHPDPReport   geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusCoCTotalPtHPDPReport   vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		COCTotalPtHPDPReportDataType data = new COCTotalPtHPDPReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setCoCTotalPtHPDPReportData(data);
		
		return responseType;
		
	}

	public void setcensusCoCTotalPtHPDPReportQuery(
			String acensusCoCTotalPtHPDPReportQuery){
		this.censusCoCTotalPtHPDPReportQuery = acensusCoCTotalPtHPDPReportQuery;
	}

}
