package gov.va.med.cds.ars.persistence;

import gov.va.med.cds.ars.exception.ValidationException;
import gov.va.med.cds.ars.requestresponse.generated.GeographicalAreaVendorPatientCountDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtACMReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.COCTotalPtACMReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.exception.PersistenceException;

import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

import org.hibernate.query.Query;
import org.hibernate.Session;

public class CensusCoCTotalPtACMReportPersistenceManager extends AbstractReadableReportsPersistenceManager 
	implements ReadableReportsPersistenceManagerInterface {
	
	protected String censusCoCTotalPtACMReportQuery;
		
	@Override
	public HTResponseType performReadReportAggregate(
			HTReportFilterType aReportFilter) throws PersistenceException, ValidationException {
		
		COCTotalPtACMReportFilterType filter = aReportFilter.getCoCTotalPtACMReportFilter();

		XMLGregorianCalendar xmlStartDate = filter.getStartDate();
		XMLGregorianCalendar xmlEndDate = filter.getEndDate();
		
		java.sql.Date sqlStartDate = formatDate(xmlStartDate);
		java.sql.Date sqlEndDate = formatDate(xmlEndDate);
		Session aSession = this.sessionFactory.getCurrentSession();
		
		List<CensusPatientCountDataType> results = null;
		
		try {
			Query query = aSession.getNamedQuery( censusCoCTotalPtACMReportQuery );
			
				String location  = filter.getGeographicalArea().getLocation();
				String vendor = filter.getVendor();
			    query.setDate("startDate", sqlStartDate);
			    query.setDate("endDate", sqlEndDate);
			    query.setString( "geographicalArea", location );
			    query.setString( "vendor", vendor );
			
			    if ( LOGGER.isDebugEnabled() )
			    {
			        LOGGER.debug("========== Calling CensusCoCTotalPtACMReport query procedure: " + censusCoCTotalPtACMReportQuery + " ======"  );
			        LOGGER.debug( " CensusCoCTotalPtACMReport   startDate: '" + sqlStartDate  + "'");
			        LOGGER.debug( " CensusCoCTotalPtACMReport   endDate: '" + sqlEndDate + "'");
			        LOGGER.debug( " CensusCoCTotalPtACMReport   geographicalArea location: '" + location + "'");
			        LOGGER.debug( " CensusCoCTotalPtACMReport   vendor: '" + vendor + "'");
			    }
			    
			     results = (List<CensusPatientCountDataType>)queryForReportData(query);			    
		} finally{ 
			if( aSession != null){
				aSession.close();
			}
		}
		
		List <GeographicalAreaVendorPatientCountDataType>  listData = null;
		listData =  CensusTransformData.transformDataProcess(results);
		COCTotalPtACMReportDataType data = new COCTotalPtACMReportDataType();
		data.getGeographicalAreaData().addAll(listData);
		data.setReportID(filter.getReportID());
	
	    responseType.setCoCTotalPtACMReportData(data);
		
		return responseType;
		
	}

	public void setcensusCoCTotalPtACMReportQuery(
			String acensusCoCTotalPtACMReportQuery){
		this.censusCoCTotalPtACMReportQuery = acensusCoCTotalPtACMReportQuery;
	}

}
