

package gov.va.med.cds.ars.exceptionframework;


import gov.va.med.cds.exceptionframework.ExceptionInfo;

import java.util.List;


/**
 * Used for logging the exceptions using loggers getting the error codes getting client messages placing exceptions on
 * communication queues (not implemented)
 */
public interface ExceptionHandlerInterface
{
    /**
     * Handle cds exceptions and runtime exceptions to get messages and error codes. Handles runtime exceptions and
     * sends cdsbaseexceptions to the more complex handler.
     * 
     * @param exception - CDS or Runtime exception being handled. *
     * @param requestId - unique request Id provided by the client
     * 
     */
    void handleException( RuntimeException exception, String entryPoint, String requestId, String uniqueIdentifier, String applicationName );


    /**
     * Gets the list of ExceptionInfo objects that contain the information about the exception being handled.
     * 
     * @return Exception Info objects list.
     */
    List<ExceptionInfo> getExceptionInfoList( String uniqueIdentifier );


    /**
     * Clears the Exception Info objects list.
     */
    void clear( String uniqueIdentifier );


    /**
     * Checks if the list of Exception Info objects is null.
     * 
     * @return True if the list is null.
     */
    boolean hasErrors( String uniqueIdentifier );

}
