<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <!-- The output is ER7 encoded HL7, so we're doing straight text. -->
  <xsl:output method="text" indent="no" omit-xml-declaration="yes"/>

  <!-- *******************************************************************************************-->
  <!-- *                              Build Link Patient Message                                                                     *-->
  <!-- *******************************************************************************************-->
  <!--
  MSH^~|\&^MPIF TRIGGER^200M~MPI.DNS      URL        ~DNS^MPIF TRIGGER^200HD~domainname~DNS^20050929175914-0500^^ACK~A24^200914866^T^2.4^^^AL^NE^USA
MSA^AA^55385071
  -->
  <xsl:template match="mpi">MSH^~|\&amp;^MPIF TRIGGER^200M~<xsl:value-of select="receivingFacility"/>~DNS^MPIF TRIGGER^<xsl:value-of select="stationNumber"/>~<xsl:value-of select="sendingFacility"/>~DNS^<xsl:value-of select="messageDateTime"/>^^ACK~A24^<xsl:value-of select="responseMessageControlId"/>^<xsl:value-of select="environmentFlag"/>^2.4^^^AL^NE^USA
MSA^AA^<xsl:value-of select="messageControlId"/>
  </xsl:template>
</xsl:stylesheet>
