<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<!-- The output is ER7 encoded HL7, so we're doing straight text. -->
	<xsl:output method="text" indent="no" omit-xml-declaration="yes"/>
	
	<xsl:template match="mpi">MSH^~|\&amp;^MPI^200HD~<xsl:value-of select="sendingFacility"/>~DNS^MPI^200M~<xsl:value-of select="receivingFacility"/>~DNS^<xsl:value-of select="messageDateTime"/>^^RSP~K22^<xsl:value-of select="responseMessageControlId"/>^T^2.4^^^AL^NE^
MSA^AA^<xsl:value-of select="messageControlId"/>
QAK^<xsl:value-of select="messageControlId"/>^OK^Q22~FIND CANDIDATES~HL72.4^1
<xsl:apply-templates select="graph/instance[@role='patient']"/>
	</xsl:template>
	
	<xsl:template match="graph/instance[@role='patient']">PID^1^^<xsl:for-each select="instance[@role='identifiers']/instance[@role='patientIdentifier']"><xsl:call-template name="buildIdentifier"/></xsl:for-each>^^<xsl:value-of select="instance[@type='PatientName' and @role='patientName']/attribute[@type='PlainText' and @name='lastName']/field"/>~<xsl:value-of select="instance[@type='PatientName' and @role='patientName']/attribute[@type='PlainText' and @name='firstName']/field"/>~<xsl:value-of select="instance[@type='PatientName' and @role='patientName']/attribute[@type='PlainText' and @name='middleName']/field"/>~<xsl:value-of select="instance[@type='PatientName' and @role='patientName']/attribute[@type='PlainText' and @name='suffix']/field"/>~~~L^^<xsl:value-of select="attribute[@type='DateTime' and @name='dateOfBirth']/field[@name='value']"/>^M^^^^^^^^^^^^^^^^^^^^^^^
	</xsl:template>
	
	<!-- *******************************************************************************************-->
 	<!-- *             Get the Local Patient Identifier from the Patient Element                  *-->
	<!-- *******************************************************************************************--> 
	<xsl:template name="getLocalPid">
		<xsl:value-of select="graph/instance[@type='Patient' and @role='patient']/instance[@type='List' and @role='identifiers']/instance/attribute[@name='id']/field[../../attribute[@name='identifierTypeCode']/field='PI']"/>
	</xsl:template>
	
	<!-- *******************************************************************************************-->
 	<!-- *           Get the Domain of the Local Identifier from the Patient Element          *-->
	<!-- *******************************************************************************************--> 
	<xsl:template name="getDomain">
		<xsl:value-of select="substring-after(graph/instance[@type='Patient' and @role='patient']/instance[@type='List' and @role='identifiers']/instance/attribute[@name='assigningFacility']/field[@name='authority_id.naming_entity' and ../../attribute[@name='identifierTypeCode']/field='PI'], '/')"/>
	</xsl:template>

	<!-- *******************************************************************************************-->
 	<!-- *                              Builds identifier PID-3 HL7.                                *-->
	<!-- *******************************************************************************************--> 
	<xsl:template name="buildIdentifier">
		<xsl:variable name="stationNo">
			<xsl:choose>
				<xsl:when test="substring-after(attribute[@name='assigningFacility']/field[@name='authority_id.naming_entity'], '/') != ''">
					<xsl:value-of select="substring-after(attribute[@name='assigningFacility']/field[@name='authority_id.naming_entity'], '/')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="attribute[@name='assigningFacility']/field[@name='authority_id.naming_entity']"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="attribute[@name='id']/field[@name='value']"/>~~~<xsl:value-of select="attribute[@name='assigningAuthority']/field[@name='local_name']"/>&amp;&amp;<xsl:value-of select="attribute[@name='assigningAuthority']/field[@name='lauthority_id.naming_entity']"/>~<xsl:value-of select="attribute[@name='identifierTypeCode']/field[@name='value']"/>~<xsl:value-of select="attribute[@name='assigningFacility']/field[@name='local_name']"/>&amp;<xsl:value-of select="$stationNo"/>&amp;L<xsl:if test="following-sibling::*">|</xsl:if>
	</xsl:template>
</xsl:stylesheet>
