<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:hl7StringEncoder="xalan://gov.va.med.hds.hdr.hl7.HL7DelimiterEncoder">
  <!-- The output is ER7 encoded HL7, so we're doing straight text. -->
  <xsl:output method="text" indent="no" omit-xml-declaration="yes"/>

  <!-- *******************************************************************************************-->
  <!-- *                              Build Link Patient Message                                                                     *-->
  <!-- *******************************************************************************************-->
  <xsl:template match="mpi">MSH^~|\&amp;^MPIF TRIGGER^<xsl:value-of select="stationNumber"/>~<xsl:value-of select="hl7StringEncoder:encodeHL7Delimiters(sendingFacility,'^~|\&amp;')"/>~DNS^MPIF TRIGGER^200M~<xsl:value-of select="hl7StringEncoder:encodeHL7Delimiters(receivingFacility,'^~|\&amp;')"/>~DNS^<xsl:value-of select="messageDateTime"/>^^ADT~A24^<xsl:value-of select="messageControlId"/>^<xsl:value-of select="environmentFlag"/>^2.4^^^AL^AL^
EVN^A24^^
PID^1^^<xsl:call-template name="getNationalPid"/>~~~USVHA&amp;&amp;0363~NI~VA FACILITY ID&amp;200M&amp;L|<xsl:call-template name="getLocalPid"/>~~~USVHA&amp;&amp;0363~PI~VA FACILITY ID&amp;<xsl:value-of select="stationNumber"/>&amp;L^^<xsl:call-template name="getLastName"/>~<xsl:call-template name="getFirstName"/>~<xsl:call-template name="getMiddleName"/>~<xsl:call-template name="getSuffix"/>~~~L^^<xsl:call-template name="getDateOfBirth"/>^<xsl:call-template name="getSex"/>^^^^^^^^^^^^^^^^^^^^^^^
PID^2^^<xsl:call-template name="getNationalPid"/>~~~USVHA&amp;&amp;0363~NI~VA FACILITY ID&amp;200M&amp;L|<xsl:call-template name="getLocalPid"/>~~~USVHA&amp;&amp;0363~PI~VA FACILITY ID&amp;<xsl:value-of select="stationNumber"/>&amp;L^^<xsl:call-template name="getLastName"/>~<xsl:call-template name="getFirstName"/>~<xsl:call-template name="getMiddleName"/>~<xsl:call-template name="getSuffix"/>~~~L^^<xsl:call-template name="getDateOfBirth"/>^<xsl:call-template name="getSex"/>^^^^^^^^^^^^^^^^^^^^^^^
  </xsl:template>

  	<!-- *******************************************************************************************-->
   	<!-- *             Get the Local Patient Identifier from the Patient Element                                    *-->
  	<!-- *******************************************************************************************-->
  	<xsl:template name="getLocalPid">
    		<xsl:value-of select="graph/instance[@type='Patient' and @role='patient']/instance[@type='List' and @role='identifiers']/instance/attribute[@name='id']/field[../../attribute[@name='identifierTypeCode']/field='PI']"/>
  	</xsl:template>

	<!-- *******************************************************************************************-->
   	<!-- *             Get the National Patient Identifier from the Patient Element                              *-->
  	<!-- *******************************************************************************************-->
  	<xsl:template name="getNationalPid">
    		<xsl:value-of select="graph/instance[@type='Patient' and @role='patient']/instance[@type='List' and @role='identifiers']/instance/attribute[@name='id']/field[../../attribute[@name='identifierTypeCode']/field='NI']"/>
  	</xsl:template>

	<!-- *******************************************************************************************-->
	<!-- *           Get the Last Name from the Patient Element                                                          *-->
	<!-- *******************************************************************************************-->
  	<xsl:template name="getLastName">
  		<xsl:value-of select="hl7StringEncoder:encodeHL7Delimiters(graph/instance[@type='Patient' and @role='patient']/instance[@role='patientName' and @type='PatientName']/attribute[@name='lastName' and @type='PlainText']/field, '^~|\&amp;')"/>
  	</xsl:template>
  	
  	<!-- *******************************************************************************************-->
	<!-- *           Get the First Name from the Patient Element                                                          *-->
	<!-- *******************************************************************************************-->
  	<xsl:template name="getFirstName">
  		<xsl:value-of select="hl7StringEncoder:encodeHL7Delimiters(graph/instance[@type='Patient' and @role='patient']/instance[@role='patientName' and @type='PatientName']/attribute[@name='firstName' and @type='PlainText']/field, '^~|\&amp;')"/>
  	</xsl:template>
  	
  	<!-- *******************************************************************************************-->
	<!-- *           Get the Middle Name from the Patient Element                                                      *-->
	<!-- *******************************************************************************************-->
  	<xsl:template name="getMiddleName">
  		<xsl:value-of select="hl7StringEncoder:encodeHL7Delimiters(graph/instance[@type='Patient' and @role='patient']/instance[@role='patientName' and @type='PatientName']/attribute[@name='middleName' and @type='PlainText']/field, '^~|\&amp;')"/>
  	</xsl:template>
  	
  	<!-- *******************************************************************************************-->
	<!-- *           Get the Suffix from the Patient Element                                                                    *-->
	<!-- *******************************************************************************************-->
  	<xsl:template name="getSuffix">
  		<xsl:value-of select="hl7StringEncoder:encodeHL7Delimiters(graph/instance[@type='Patient' and @role='patient']/instance[@role='patientName' and @type='PatientName']/attribute[@name='suffix' and @type='PlainText']/field, '^~|\&amp;')"/>
  	</xsl:template>
  	
  	<!-- *******************************************************************************************-->
	<!-- *           Get the Date of Birth from the Patient Element                                                        *-->
	<!-- *******************************************************************************************-->
  	<xsl:template name="getDateOfBirth">
  		<xsl:value-of select="hl7StringEncoder:encodeHL7Delimiters(graph/instance[@type='Patient' and @role='patient']/attribute[@name='dateOfBirth' and @type='DateTime']/field, '^~|\&amp;')"/>
  	</xsl:template>
  	
  	<!-- *******************************************************************************************-->
	<!-- *           Get the Sex from the Patient Element                                                                       *-->
	<!-- *******************************************************************************************-->
  	<xsl:template name="getSex">
  		<xsl:value-of select="hl7StringEncoder:encodeHL7Delimiters(graph/instance[@type='Patient' and @role='patient']/attribute[@name='sex' and @type='PlainText']/field, '^~|\&amp;')"/>
  	</xsl:template>

</xsl:stylesheet>
