<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:hl7StringEncoder="xalan://gov.va.med.hds.hdr.hl7.HL7DelimiterEncoder">
	
  <!-- The output is ER7 encoded HL7, so we're doing straight text. -->
  <xsl:output method="text" indent="no" omit-xml-declaration="yes"/>

  <!-- *******************************************************************************************-->
   <!-- *                              Build Find Candidates Message                                   *-->
  <!-- *******************************************************************************************-->
  
  <xsl:template match="mpi">MSH^~|\&amp;^MPI^<xsl:value-of select="stationNumber"/>~<xsl:value-of select="hl7StringEncoder:encodeHL7Delimiters(sendingFacility, '^~|\&amp;')"/>~DNS^MPI^200M~<xsl:value-of select="hl7StringEncoder:encodeHL7Delimiters(receivingFacility, '^~|\&amp;')"/>~DNS^<xsl:value-of select="messageDateTime"/>^^QBP~Q22^<xsl:value-of select="messageControlId"/>^<xsl:value-of select="environmentFlag"/>^2.4^^^AL^AL^
QPD^Q22~FIND CANDIDATES~HL72.4^<xsl:value-of select="messageControlId"/>^@PID.3.1~<xsl:call-template name="getLocalPid"/>|@PID.3.2~""|@PID.3.3~""|@PID.3.4~USVHA&amp;&amp;0363|@PID.3.5~PI|@PID.3.6~VA FACILITY ID&amp;<xsl:call-template name="getDomain"/>&amp;L^DHN SP ^ . ^<xsl:value-of select="recordLinkingAttribute"/>
RCP^I^1~RD^R^^N^^
  </xsl:template>

  <!-- *******************************************************************************************-->
   <!-- *             Get the Local Patient Identifier from the Patient Element                  *-->
  <!-- *******************************************************************************************-->
  <xsl:template name="getLocalPid">
    <xsl:value-of select="graph/instance[@type='Patient' and @role='patient']/instance[@type='List' and @role='identifiers']/instance/attribute[@name='id']/field[../../attribute[@name='identifierTypeCode']/field='PI']"/>
  </xsl:template>

  <!-- *******************************************************************************************-->
   <!-- *           Get the Domain of the Local Identifier from the Patient Element          *-->
  <!-- *******************************************************************************************-->
  <xsl:template name="getDomain">
    <xsl:value-of select="substring-after(graph/instance[@type='Patient' and @role='patient']/instance[@type='List' and @role='identifiers']/instance/attribute[@name='assigningFacility']/field[@name='authority_id.naming_entity' and ../../attribute[@name='identifierTypeCode']/field='PI'], '/')"/>
  </xsl:template>
  
</xsl:stylesheet>
