package gov.va.med.cds.testharness.vhim400.builders;

import org.dom4j.Document;
import org.dom4j.Element;

import java.util.List;
import org.dom4j.Element;
import org.apache.commons.collections4.map.MultiValueMap;

public class SensitivePatientDataAccessBuilderFactory implements SensitivePatientDataAccessBuilderFactoryInterface {
	private SensitivePatientDataAccessBuilder sensitivePatientDataAccessBuilder = null;

	public void createClinicalDomainData(Document clinicalData, MultiValueMap map, String facilityId, String menuOption) {
		// call the appropriate builder and set the clinicaldata.patient.domain
		// with it
		buildSensitivePatientDataAccessData(clinicalData, map, facilityId, menuOption);
	}
	
	public void createClinicalDomainData(Document clinicalData, MultiValueMap map, String facilityId1, String facilityId2, String menuOption ) {
		// call the appropriate builder and set the clinicaldata.patient.domain
		// with it
		buildSensitivePatientDataAccessData(clinicalData, map, facilityId1, facilityId2, menuOption);
	}
	
	private void buildSensitivePatientDataAccessData(Document clinicalData, MultiValueMap map, String facilityId, String menuOption) {
		Element rootElement = clinicalData.getRootElement();

		Element patient = rootElement.element("patient");

		Element sensitivePatientDataAccess = sensitivePatientDataAccessBuilder.makePatientData(map, facilityId, menuOption);

		patient.add(sensitivePatientDataAccess);
		
	}

	private void buildSensitivePatientDataAccessData(Document clinicalData, MultiValueMap map, String facilityId1, String facilityId2, String menuOption) {
		Element rootElement = clinicalData.getRootElement();

		Element patient = rootElement.element("patient");

		Element sensitivePatientDataAccess = sensitivePatientDataAccessBuilder.makePatientData(map, facilityId1, facilityId2, menuOption);

		patient.add(sensitivePatientDataAccess);
		
	}
	
	public void setSensitivePatientDataAccessBuilder(
			SensitivePatientDataAccessBuilder sensitivePatientDataAccessBuilder) {
		this.sensitivePatientDataAccessBuilder = sensitivePatientDataAccessBuilder;
	}

	public void createClinicalDomainData(Document clinicalData, int cnt, Element patientIdentifier) {

	}
}
